---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: 29-3-2011
-- DESCRIPCIN: Implementacin del TAD Socio
---------------------------------------------------------------------
with Ada.Strings, ada.Integer_Text_IO;
use Ada.Strings, ada.integer_Text_IO;

package body socio is

   ------------------------------------------------------------------
   function dni(socio: tpSocio) return tpDNI is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto el DNI del socio
   ------------------------------------------------------------------
   begin
      return socio.dni;
   end dni;
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function crear(dni: tpDNI; letra: character;
         nombre, apellidos: String; telefono: integer)
         return tpSocio is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un nuevo socio creado a travs de los valores
   --       de los parmetros
   ------------------------------------------------------------------
      s: tpSocio;
   begin            
      s.dni := dni;
      s.letra := letra;
      s.nombre := To_Bounded_String(nombre, RIGHT);
      s.apellidos := To_Bounded_String(apellidos, RIGHT);
      s.telefono := telefono;
      return s;
   end crear;
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function cadena(socio: tpSocio) return String is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del socio
   ------------------------------------------------------------------
   begin
      return tpDNI'image(socio.dni) & '-' & socio.letra & ", "
         & to_string(socio.nombre & ' ' & socio.apellidos) & " (tf: "            
         & integer'image(socio.telefono) & ')';
   end cadena;
   ------------------------------------------------------------------
   
   package tpDNI_io is new integer_io(tpDNI);
   use tpDNI_io;

   ------------------------------------------------------------------
   procedure leer(f: in file_type; socio: out tpSocio) is
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las cinco siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - un entero que representa un DNI
   --        - un caracter que representa la letra del DNI
   --        - una cadena de caracteres que representan apellidos
   --        - una cadena de caracteres que representan un nombre
   --        - un entero que representa un nmero de telfono  
   ------------------------------------------------------------------
   -- Pots: Ha ledo las cinco siguientes lneas de f y el valor del
   --       parmetro socio ha sido inicializado con los datos ledos
   ------------------------------------------------------------------
      dni: tpDNI;
      letra: character;
      nombre, apellidos: string(1..250);
      longNombre, longApellidos: natural;
      telefono: natural;
   begin
      get(f, dni); skip_line(f);
      get(f, letra); skip_line(f);
      get_line(f, nombre, longNombre);
      get_line(f, apellidos, longApellidos);
      get(f, telefono); skip_line(f, 2);
      
      socio := crear(dni, letra, nombre(1..longNombre),
         apellidos(1..longApellidos), telefono);
   end leer;
end socio;
   

