-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Programa que simula un conjunto de operaciones sobre una base
--              datos para una biblioteca especificadas en un fichero de texto
-------------------------------------------------------------------------------
with Biblioteca, Socio, Libro, Prestamo, ProcesadorGenerico;
use  Biblioteca, Socio, Libro, Prestamo, ProcesadorGenerico;
with Ada.Exceptions, Ada.Calendar, Ada.Numerics.Float_Random;
use  Ada.Exceptions, Ada.Calendar, Ada.Numerics.Float_Random;
with Ada.Text_IO, Ada.Float_Text_IO;
use  Ada.Text_IO, Ada.Float_Text_IO;

-------------------------------------------------------------------------------
-- Pre:  Existe un fichero denominado "traza.txt" que especifica un conjunto de
--       operaciones sobre una base datos para una biblioteca
-------------------------------------------------------------------------------
-- Post: Ha ejecutado las operaciones especificadas en el fichero y ha
--       informado del tiempo total que le ha costado realizarlas
-------------------------------------------------------------------------------
procedure Simulacion is

   -- generador de nmeros aleatorios global
   g: generator;

   ----------------------------------------------------------------------------
   -- Pre:  f est en modo lectura y asociado con un fichero que especifica un
   --       conjunto de operaciones sobre una base datos para una biblioteca
   ----------------------------------------------------------------------------
   -- Post: Ha ejecutado las operaciones especificadas en el fichero, esperando
   --       un tiempo aleatorio de no ms de 0.1 segundos entre cada operacin
   ----------------------------------------------------------------------------
   procedure simularTraza(idCliente: in integer; f: in file_type) is
 
      procedure procesarSocio is new procesar(tpSocio, dni, leer, 
            Biblioteca.buscarSocio, Biblioteca.insertarSocio,
            Biblioteca.modificarSocio, Biblioteca.eliminarSocio);

      procedure procesarLibro is new procesar(tpLibro, isbn, leer, 
            Biblioteca.buscarLibro, Biblioteca.insertarLibro,
            Biblioteca.modificarLibro, Biblioteca.eliminarLibro);

      procedure procesarPrestamo is new procesar(tpPrestamo, id, leer, 
            Biblioteca.buscarPrestamo, Biblioteca.insertarPrestamo,
            Biblioteca.modificarPrestamo, Biblioteca.eliminarPrestamo);

      operacion: string(1..2);
   begin
      while not end_of_file(f) loop
         get(f, operacion); skip_line(f);
         if operacion(2) = 'S' then
            procesarSocio(operacion(1), f, SOCIOS, idCliente);
         elsif operacion(2) = 'L' then
            procesarLibro(operacion(1), f, LIBROS, idCliente);
         elsif operacion(2) = 'P' then
            procesarPrestamo(operacion(1), f, PRESTAMOS, idCliente);
         elsif operacion = "VT" then          
            Biblioteca.validarTransaccion(idCliente);
         elsif operacion = "CT" then
            Biblioteca.cancelarTransaccion(idCliente);
         end if;
         delay duration(random(g)*0.01); 
      end loop;
   end simularTraza;
   
   f: file_type;
   inicio, fin: time;
begin
   reset(g);
   inicio := clock;

   begin
      open(f, IN_FILE, "traza-8.txt");
      simularTraza(1, f);
      close(f);
   exception
      when ex: others =>
         put_line(exception_name(ex)); put_line(exception_message(ex));
   end;
   
   fin := clock;
   new_line;
   put("Tiempo total de simulacin: ");
   put(float(fin-inicio), 1, 2, 0);
   new_line;
end Simulacion;

