-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Especificacion del procedimento genrico que procesa
--              operaciones de una determinada entidad sobre la base de datos
-------------------------------------------------------------------------------
with Biblioteca;
use  Biblioteca;
with Ada.Text_IO;
use  Ada.Text_IO;

package ProcesadorGenerico is

   -------------------------------------------------------------------------
   -- Especificacion del procedimento genrico que procesa operaciones de una
   -- determinada entidad (socios, libros o prstamos, representadas por el 
   -- parmetro tipo tpDato) sobre la base de datos
   -- Requiere para su instanciacn indicar, adems,
   --  - la funcin que proporciona la clave de un dato de tipo tpDato,
   --  - el procedimiento que lee un dato de tipo tpDato de un fichero de texto
   --  - los procedimientos de bsqueda, insercin, modificacin y eliminacin
   --    de datos de tipo tpDato en la base de datos
   -------------------------------------------------------------------------
   generic
      type tpDato is private;
      with function clave(d: in tpDato) return tpClave;
      with procedure leer(f: file_type; dato: out tpDato);
      with procedure buscar(idCliente: tpIdCliente; laClave: tpClave; 
         dato: out tpDato; existe: out boolean);
      with procedure insertar(idCliente: tpIdCliente; dato: tpDato);
      with procedure modificar(idCliente: tpIdCliente; dato: tpDato);
      with procedure eliminar(idCliente: tpIdCliente; clave: tpClave);
   -------------------------------------------------------------------------
   procedure procesar(orden: in character; f: in file_type; tabla: tpTabla;
      idCliente: tpIdCliente);
   -------------------------------------------------------------------------
   -- Pre:  orden pertenece a {'I', 'E', 'M', 'C'}
   --       f asociado con un fichero de texto con el formato de traza de 
   --       operaciones, en modo lectura y en la lnea siguiente a una
   --       orden
   -------------------------------------------------------------------------
   -- Post: ha ledo de f el resto de la operacin descrita y la lnea en
   --       blanco que la separa de la siguiente operacin.
   --       Ha procesado la operacin, insertanto un nuevo dato, o 
   --       eliminndolo, o modificndolo o consultndolo, en funcin del
   --       valor del parmetro orden ('I', 'E', 'M', 'C', respectivamente)
   -------------------------------------------------------------------------

end ProcesadorGenerico;
