---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: Abril-2011
-- DESCRIPCIN: Especificacin del TAD Prestamo, para representar el
--              prstamo de un libro a un socio, con sus fechas de
--              prstamo y, si es aplicable, de devolucin
---------------------------------------------------------------------
with Ada.Integer_Text_IO;
use  Ada.Integer_Text_IO;

package body Prestamo is

   ------------------------------------------------------------------
   function id(prestamo: tpPrestamo) return tpIDPrestamo is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un identificador numrico del prstamo
   ------------------------------------------------------------------
   begin
      return prestamo.codSocio*1E8 + prestamo.codLibro;
   end id;
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   function crear(codSocio: tpDNI; codLibro: tpISBN)
         return tpPrestamo is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado hoy y no devuelto
   ------------------------------------------------------------------   
   begin
      return crear(codSocio, codLibro, clock);
   end crear;
   ------------------------------------------------------------------   
   
   ------------------------------------------------------------------   
   function crear(codSocio: tpDNI; codLibro: tpISBN;
         fechaPrestamo: Time) return tpPrestamo is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado en fechaPrestamo y no devuelto
   ------------------------------------------------------------------   
      p: tpPrestamo;
   begin
      p.codSocio := codSocio;
      p.codLibro := codLibro;
      p.fechaPrestamo := fechaPrestamo;
      p.devuelto := false;
      return p;
   end crear;
   ------------------------------------------------------------------   
                          
   ------------------------------------------------------------------   
   function crear(codSocio: tpDNI; codLibro: tpISBN;
         fechaPrestamo, fechaDevolucion: Time) return tpPrestamo is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado en fechaPrestamo y devuelto en fechaDevolucion
   ------------------------------------------------------------------   
      p: tpPrestamo;      
   begin
      p.codSocio := codSocio;
      p.codLibro := codLibro;
      p.fechaPrestamo := fechaPrestamo;
      p.fechaDevolucion := fechaDevolucion;
      p.devuelto := true;
      return p;
   end crear;
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function cadena(prestamo: tpPrestamo) return String is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del prstamo
   ------------------------------------------------------------------
      ---------------------------------------------------------------
      function cadena(fecha: time) return String is
      ---------------------------------------------------------------
      -- Post: Ha devuelto una representacin de la fecha
      ---------------------------------------------------------------      
         a : Year_Number; m : Month_Number; d : Day_Number;
         s: Day_Duration;
      begin
         Split(fecha, a, m, d, s);
         return integer'image(d) & integer'image(-m) & integer'image(-a);
      end cadena;
      ---------------------------------------------------------------

      ---------------------------------------------------------------
      function cadenaDevolucion(prestamo: tpPrestamo) return String is
      ---------------------------------------------------------------
      -- Post: Si el prestamo ha sido devuelto, ha devuelto una
      --       representacin de la fecha de devolucin; en caso
      --       contrario, ha devuelto la cadena "---"
      ---------------------------------------------------------------      
      begin
         if prestamo.devuelto then
            return cadena(prestamo.fechaDevolucion);
         else
            return "---";
         end if;
      end cadenaDevolucion;
   ------------------------------------------------------------------
   begin
      return tpDNI'image(prestamo.codSocio) & ","
         & tpISBN'image(prestamo.codLibro)
         & " (" & cadena(prestamo.fechaPrestamo) & ", "
         & cadenaDevolucion(prestamo) & ')';
   end cadena;
   ------------------------------------------------------------------

   package long_long_integer_io is new integer_io(long_long_integer);
   use long_long_integer_io;

   ------------------------------------------------------------------
   procedure leer(f: in file_type; prestamo: out tpPrestamo) is
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las cuatro siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - un entero que representa un DNI
   --        - un entero que representa un ISBN
   --        - 1 o 0, que representa si el prestamo se ha devuelto o
   --          no, respectivamente
   --        - 6 enteros, separados por espacios, que representan, en
   --          este orden, da, mes y ao de la fecha de prstamo y
   --          da, mes y ao de la fecha de devolucin (incluso si
   --          no se ha devuelto)
   ------------------------------------------------------------------
   -- Post: Ha ledo las cuatro siguientes lneas de f y el valor del
   --       parmetro prestamo ha sido inicializado con los datos
   --       ledos
   ------------------------------------------------------------------   
      dni: tpDNI;
      isbn: tpISBN;
      devuelto: integer;
      dP, mP, aP, dD, mD, aD: positive;
   begin
      get(f, dni); skip_line(f);
      get(f, isbn); skip_line(f);
      get(f, devuelto); skip_line(f);
      get(f, dP);
      get(f, mP);
      get(f, aP);
      get(f, dD);
      get(f, mD);
      get(f, aD); skip_line(f, 2);
      
      if devuelto=0 then
         prestamo := crear(dni, isbn, time_of(aP, mP, dP));
      else
         prestamo := crear(dni, isbn, time_of(aP, mP, dP),
            time_of(aD, mD, dD));
      end if;
   end leer;
   ------------------------------------------------------------------   

end Prestamo;

