-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Especificacin del TAD ListaTransaccional
-------------------------------------------------------------------------------

generic
   type tpDato is private;
   type tpClave is private;
   with function clave(d: in tpDato) return tpClave;
package ListaTransaccional is
   type tpLista is limited private;   
	
   ----------------------------------------------------------------------------
   procedure insertarDato(idCliente: in integer; l: in out tpLista;
      dato: in tpDato);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: dato se ha insertado temporalmente en l, hasta que idCliente valide
   --       o cancele la transaccin
   ----------------------------------------------------------------------------
	
   ----------------------------------------------------------------------------
   procedure eliminarDato(idCliente: in integer; l: in out tpLista;
      clave: in tpClave);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave "clave"
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, dicho dato
   --       ha sido eliminado temporalmente de l, hasta que idCliente valide
   --       o cancele la transaccin
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarDato(idCliente: in integer; l: in out tpLista;
      dato: in tpDato);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: Si clave(dato) es la clave de algn dato de l, dicho dato
   --       ha sido reemplazado temporalmente por "dato", hasta que idCliente
   --       valide o cancele la transaccin
   ----------------------------------------------------------------------------
  
   ----------------------------------------------------------------------------
   procedure buscar(l: in tpLista; clave: in tpClave; idCliente: in integer;
      dato: out tpDato; encontrado: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el dato
   --       de clave "clave" o lo tiene el proceso con identificador
   --       idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato y encontrado=true. En caso contrario, 
   --       encontrado=false
   ----------------------------------------------------------------------------
      
   ----------------------------------------------------------------------------
   procedure iniciarTransaccion(idCliente: in integer; l: in out tpLista;
      clave: in tpClave; encontrado: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato, encontrado=true y el proceso cuyo 
   --       identificador es igual a idCliente ha adquirido el cerrojo para
   --       operar con l. En caso contrario, encontrado=false
   ----------------------------------------------------------------------------
      
   ----------------------------------------------------------------------------
   procedure validarTransaccion(idCliente: in integer; l: in out tpLista);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente han tomado carcter definitivo y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure cancelarTransaccion(idCliente: in integer; l: in out tpLista);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente se han desechado y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------
   
private

   type tpOperacionPendiente is
      (NINGUNA, INSERCION, ELIMINACION, ACTUALIZACION);

   type tpInfo;
   type tpPtInfo is access tpInfo;

   type tpInfo is record
      dato: tpDato;
      datoTemporal: tpDato;
      idEscritor: integer := 0;
      operacionPendiente: tpOperacionPendiente := NINGUNA;
      siguiente, anterior: tpPtInfo := null;
   end record;
	
   type tpLista is record
      primero:  tpPtInfo;
   end record;
end ListaTransaccional;