-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: Abril-2011
-- DESCRIPCIN: Especificacin del TAD Libro
-------------------------------------------------------------------------------
with Ada.Strings.bounded, Ada.Text_IO;
use Ada.Strings.bounded, Ada.Text_IO;

-------------------------------------------------------------------------------
package Libro is
   
   type tpLibro is private;
   subtype tpISBN is long_long_integer range 1..1E14;
   
   ------------------------------------------------------------------
   function isbn(libro: in tpLibro) return tpISBN;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto el DNI del socio
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function crear(titulo, autor: String; isbn: tpISBN) return tpLibro;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un nuevo libro creado a travs de los valores
   --       de los parmetros
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   function cadena(libro: tpLibro) return String;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del libro
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   procedure leer(f: in file_type; libro: out tpLibro);
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las tres siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - una cadena de caracteres que representa un ttulo
   --        - una cadena de caracteres que representa un autor
   --        - un entero que representa un ISBN  
   ------------------------------------------------------------------
   -- Post: Ha ledo las tres siguientes lneas de f y el valor del
   --       parmetro libro ha sido inicializado con los datos ledos
   ------------------------------------------------------------------
      
private
   package Cadenas200 is new Generic_Bounded_Length(200);
   use cadenas200;

   type tpLibro is record
      isbn: tpISBN;
      titulo, autor: bounded_string;
   end record;
end Libro;
-------------------------------------------------------------------------------

