---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: 29-3-2011
-- DESCRIPCIN: Especificacin del TAD Socio
---------------------------------------------------------------------
with Ada.Strings.Bounded, Ada.Text_IO;
use Ada.Strings.Bounded, Ada.Text_IO;

---------------------------------------------------------------------
package socio is
   type tpSocio is private;
   subtype tpDNI is long_long_integer range 1..99_999_999;
   

   ------------------------------------------------------------------
   function dni(socio: tpSocio) return tpDNI;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto el DNI del socio
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   function crear(dni: tpDNI; letra: character;
      nombre, apellidos: String; telefono: integer) return tpSocio;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un nuevo socio creado a travs de los valores
   --       de los parmetros
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   function cadena(socio: tpSocio) return String; 
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del socio
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   procedure leer(f: in file_type; socio: out tpSocio);
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las cinco siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - un entero que representa un DNI
   --        - un caracter que representa la letra del DNI
   --        - una cadena de caracteres que representan apellidos
   --        - una cadena de caracteres que representan un nombre
   --        - un entero que representa un nmero de telfono  
   ------------------------------------------------------------------
   -- Post: Ha ledo las cinco siguientes lneas de f y el valor del
   --       parmetro socio ha sido inicializado con los datos ledos
   ------------------------------------------------------------------
   
private
   package Cadenas50 is new Generic_Bounded_Length(50);
   use cadenas50;
   type tpSocio is record
      dni: tpDNI;
      letra: character;
      apellidos, nombre: Bounded_String ;
      telefono: integer;
   end record;
end socio;
---------------------------------------------------------------------

