-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Implementacin del procedimento genrico que procesa
--              operaciones de una determinada entidad sobre la base de datos
-------------------------------------------------------------------------------
with Biblioteca;
use  Biblioteca;
with Ada.Text_IO;
use  Ada.Text_IO;

package body ProcesadorGenerico is

   package long_long_integer_io is new integer_io(long_long_integer);
   use long_long_integer_io;
   
   -------------------------------------------------------------------------
   procedure procesar(orden: in character; f: in file_type;
      tabla: tpTabla; idCliente: tpIdCliente) is
   -------------------------------------------------------------------------
   -- Pre:  orden pertenece a {'I', 'E', 'M', 'C'}
   --       f asociado con un fichero de texto con el formato de traza de 
   --       operaciones, en modo lectura y en la lnea siguiente a una
   --       orden
   -------------------------------------------------------------------------
   -- Post: ha ledo de f el resto de la operacin descrita y la lnea en
   --       blanco que la separa de la siguiente operacin.
   --       Ha procesado la operacin, insertanto un nuevo dato, o 
   --       eliminndolo, o modificndolo o consultndolo, en funcin del
   --       valor del parmetro orden ('I', 'E', 'M', 'C', respectivamente)
   -------------------------------------------------------------------------
      dato: tpDato;
      existe: boolean;
      laClave: tpClave;
      escritor: tpIdCliente;
   begin
      if orden = 'I' or orden = 'M' then
         leer(f, dato); laClave := clave(dato);
      else
         get(f, laClave); skip_line(f);
      end if;

      escritor := Biblioteca.idCerrojo(tabla, laClave);
      if orden = 'C' then
         -- Implementar protocolo de lectura para cada tipo de bloqueo:
         -- base de datos, tabla y registro
         buscar(idCliente, laClave, dato, existe);
      else   
         if escritor /= idCliente then
            Biblioteca.iniciarTransaccion(tabla, laClave, idCliente, existe);
         end if;
         if orden = 'I' then
            insertar(idCliente, dato);
         elsif orden = 'M' then 
            modificar(idCliente, dato);
         elsif orden = 'E' then
            eliminar(idCliente, laClave);
         end if;
      end if;
   end procesar;
   -------------------------------------------------------------------------
 
end ProcesadorGenerico;

