-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Especificacin del TAD ListaTransaccional
-------------------------------------------------------------------------------
with Unchecked_Deallocation;
package body ListaTransaccional is

   ----------------------------------------------------------------------------
   function buscar(l: in tpLista; claveBusqueda: in tpClave)
         return tpPtInfo is            
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: si hay en la lista un elemento d tal que clave(d)=clave 
   --      devuelve la posicin de ese dato d;
   --      en caso contrario, devuelve null
   ----------------------------------------------------------------------------
      puntero: tpPtInfo;
   begin
      puntero := l.primero;
      while puntero /= null and then clave(puntero.dato) /= claveBusqueda loop
         puntero := puntero.siguiente;
      end loop;
      -- puntero = null or else clave(puntero.dato) = claveBusqueda
      return puntero;
   end buscar;
   ------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarDato(idCliente: in integer; l: in out tpLista;
         dato: in tpDato) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: dato se ha insertado temporalmente en l, hasta que idCliente valide
   --       o cancele la transaccin
   ----------------------------------------------------------------------------
      puntero: tpPtInfo;
   begin
     if l.primero = null then
         l.primero := new tpInfo;
         puntero := l.primero;
      else
         puntero := l.primero;
         while puntero.siguiente /= null loop
            puntero := puntero.siguiente;
         end loop;
         puntero.siguiente := new tpInfo;
         puntero.siguiente.anterior := puntero;
         puntero := puntero.siguiente;
      end if;
      puntero.dato := dato;
      puntero.idEscritor := idCliente;
      puntero.operacionPendiente := INSERCION;
   end insertarDato;
   ----------------------------------------------------------------------------
	
   ----------------------------------------------------------------------------
   procedure eliminarDato(idCliente: in integer; l: in out tpLista;
         clave: in tpClave) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave "clave"
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, dicho dato
   --       ha sido eliminado temporalmente de l, hasta que idCliente valide
   --       o cancele la transaccin
   ----------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave);
   begin
      if puntero /= null then
         puntero.idEscritor := idCliente;
         puntero.operacionPendiente := ELIMINACION;
      end if;
   end eliminarDato;
   ----------------------------------------------------------------------------
	
   ----------------------------------------------------------------------------
   procedure modificarDato(idCliente: in integer; l: in out tpLista;
         dato: in tpDato) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: Si clave(dato) es la clave de algn dato de l, dicho dato
   --       ha sido reemplazado temporalmente por "dato", hasta que idCliente
   --       valide o cancele la transaccin
   ----------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave(dato));
   begin
      if puntero /= null then
         puntero.idEscritor := idCliente;
         puntero.operacionPendiente := ACTUALIZACION;
         puntero.datoTemporal:= dato;
      end if;
   end modificarDato;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure buscar(l: in tpLista; clave: in tpClave; idCliente: in integer;
                    dato: out tpDato; encontrado: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el dato
   --       de clave "clave" o lo tiene el proceso con identificador
   --       idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato y encontrado=true. En caso contrario, 
   --       encontrado=false
   ----------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave);
   begin
      if puntero /= null then
         dato := puntero.dato;
         encontrado := true;
      else
         encontrado := false;
      end if;
   end buscar;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure iniciarTransaccion(idCliente: in integer; l: in out tpLista;
         clave: in tpClave; encontrado: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato, encontrado=true y el proceso cuyo 
   --       identificador es igual a idCliente ha adquirido el cerrojo para
   --       operar con l. En caso contrario, encontrado=false
   ----------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave);
   begin
      if puntero /= null then
         puntero.idEscritor := idCliente;
         encontrado := true;
      else
         encontrado := false;
      end if;
   end iniciarTransaccion;
   ----------------------------------------------------------------------------
   
   procedure liberar is new Unchecked_Deallocation(tpInfo, tpPtInfo);
         
   ----------------------------------------------------------------------------
   procedure validarTransaccion(idCliente: in integer; l: in out tpLista) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente han tomado carcter definitivo y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------
      puntero: tpPtInfo := l.primero;
      borrar: tpPtInfo := null;
   begin
      while puntero /= null loop
         if puntero.idEscritor = idCliente then
            case puntero.operacionPendiente is
               when INSERCION => null;
               when ELIMINACION =>
                  if puntero.siguiente /= null then
                     puntero.siguiente.anterior := puntero.anterior;
                  end if;
                  if puntero.anterior /= null then
                     puntero.anterior.siguiente := puntero.siguiente;
                  else
                     l.primero := null;
                  end if;
                  borrar := puntero;              
               when ACTUALIZACION => 
                  puntero.dato := puntero.datoTemporal;
               when NINGUNA =>
                  raise PROGRAM_ERROR;
            end case;
            puntero.operacionPendiente := NINGUNA;
            puntero.idEscritor := 0;
         end if;
         puntero := puntero.siguiente;
         if borrar /= null then
            liberar(borrar);
         end if;
      end loop;
   end validarTransaccion;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure cancelarTransaccion(idCliente: in integer; l: in out tpLista) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente se han desechado y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------
   begin
      -- Pendiente de implementar
      null;
   end cancelarTransaccion;
   ----------------------------------------------------------------------------
    
end ListaTransaccional;
-------------------------------------------------------------------------------

