-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: abril-2011
-- DESCRIPCIN: Especificacin del TAD Biblioteca
-------------------------------------------------------------------------------
with ListaTransaccional, Libro, Socio, Prestamo;
use  Libro, Socio, Prestamo;

-------------------------------------------------------------------------------
package Biblioteca is
   
   MAX_CLIENTES: constant positive := 8;
   subtype tpIdCliente is natural range 0..MAX_CLIENTES;
   subtype tpClave is long_long_integer;
   
   type tpTabla is (SOCIOS, LIBROS, PRESTAMOS);

   ----------------------------------------------------------------------------
   procedure buscarSocio(idCliente: in tpIdCliente; dni: in tpDNI; 
      socio: out tpSocio; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el socio
   --       de clave "dni" de la base de datos o lo tiene el proceso con
   --       identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio, el valor del parmetro
   --       "socio" es igual a dicho dato y existe=true. En caso contrario, 
   --       existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarSocio(idCliente: in tpIdCliente; socio: in tpSocio);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de DNI sea dni(socio)
   ----------------------------------------------------------------------------
   -- Post: El socio se ha insertado temporalmente en la base de datos, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarSocio(idCliente: in tpIdCliente; socio: in tpSocio);   
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de DNI sea dni(socio)
   ----------------------------------------------------------------------------
   -- Post: Si el DNI de socio es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado temporalmente por "socio", hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarSocio(idCliente: in tpIdCliente; dni: in tpDNI);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de clave "dni"
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio de la biblioteca, dicho
   --       socio ha sido eliminado temporalmente de la biblioteca, hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------


   ----------------------------------------------------------------------------
   procedure buscarLibro(idCliente: in tpIdCliente; isbn: in tpISBN;
      libro: out tpLibro; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el libro
   --       de clave "isbn" de la base de datos o lo tiene el proceso con
   --       identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, el valor del
   --       parmetro "libro" es igual a dicho dato y existe=true. En caso
   --       contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------


   ----------------------------------------------------------------------------
   procedure insertarLibro(idCliente: in tpIdCliente; libro: in tpLibro);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el libro de la base de datos cuyo valor
   --       de ISBN sea isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: El libro se ha insertado temporalmente en la base de datos, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarLibro(idCliente: in tpIdCliente; libro: in tpLibro);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de ISBN sea isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: Si el ISBN de "libro" es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado temporalmente por "libro", hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarLibro(idCliente: in tpIdCliente; isbn: in tpISBN);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el libro de clave "isbn"
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, dicho
   --       libro ha sido eliminado temporalmente de la biblioteca, hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------


   ----------------------------------------------------------------------------
   procedure buscarPrestamo(idCliente: in tpIdCliente; id: in tpIdPrestamo;
         prestamo: out tpPrestamo; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el
   --       prstamo de clave "id" de la base de datos o lo tiene el proceso
   --       con identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, el valor
   --       del parmetro "prestamo" es igual a dicho dato y existe=true. En
   --       caso contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarPrestamo(idCliente: in integer; prestamo: in tpPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo de la base de datos cuyo
   --       identificador sea id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: El prstamo se ha insertado temporalmente en la base de datos,
   --       hasta que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarPrestamo(idCliente: in integer; prestamo: in tpPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo de la base de datos cuyo
   --       identificador sea id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: Si el identificador de "prestamo" es la clave de algn prestamo de
   --       la biblioteca, dicho dato ha sido reemplazado temporalmente por
   --       "prestamo", hasta que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarPrestamo(idCliente: in integer; id: in tpIdPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo con identificador "id"
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, dicho
   --       prstamo ha sido eliminado temporalmente de la biblioteca, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------


   ----------------------------------------------------------------------------
   function idCerrojo(tabla: in tpTabla; clave: in tpClave) return tpIdCliente;      
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Ha devuelto el identificador de la tarea que tiene el cerrojo para
   --       operar con el dato de la tabla "tabla que tiene por clave "clave",
   --       o 0 si tal dato no existe o ninguna taera tiene el cerrojo
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure iniciarTransaccion(tabla: in tpTabla; clave: in tpClave;
         idCliente: in tpIdCliente; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de la tabla "tabla",
   --       existe=true y el proceso cuyo 
   --       identificador es igual a idCliente ha adquirido el cerrojo para
   --       operar con l. En caso contrario, existe=false
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure validarTransaccion(idCliente: integer);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente han tomado carcter definitivo y se han
   --       liberado los cerrojos que poseyera
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure cancelarTransaccion(idCliente: integer);
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente se han desechado y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------

private
   package listaSocios is new ListaTransaccional(tpSocio, tpDNI, dni);
   package listaLibros is new ListaTransaccional(tpLibro, tpISBN, isbn);
   package listaPrestamos is
      new ListaTransaccional(tpPrestamo, tpIDPrestamo, id);
   
   tablaSocios: listaSocios.tpLista;
   tablaLibros: listaLibros.tpLista;
   tablaPrestamos: listaPrestamos.tpLista;
end Biblioteca;
-------------------------------------------------------------------------------
