---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2010-11
-- FECHA LTIMA REVISION: 30-3-2011
-- DESCRIPCIN: Especificacin del TAD Biblioteca
---------------------------------------------------------------------
with ada.text_io, ada.integer_text_io;
use  ada.text_io, ada.integer_text_io;

package body Biblioteca is
   
   use listaSocios, listaLibros, listaPrestamos;
   
   
   -------------------
   --Gestin de socios
   -------------------
   ----------------------------------------------------------------------------
   procedure buscarSocio(idCliente: in tpIdCliente; dni: in tpDNI;
      socio: out tpSocio; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el socio
   --       de clave "dni" de la base de datos o lo tiene el proceso con
   --       identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio, el valor del parmetro
   --       "socio" es igual a dicho dato y existe=true. En caso contrario, 
   --       existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaSocios, dni, idCliente, socio, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(socio));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpDNI'image(dni));
      end if;
   end buscarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarSocio(idCliente: in tpIdCliente; socio: in tpSocio) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de DNI sea dni(socio)
   ----------------------------------------------------------------------------
   -- Post: El socio se ha insertado temporalmente en la base de datos, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(idCliente, tablaSocios, socio);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado "
         & cadena(socio));
   end insertarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarSocio(idCliente: in tpIdCliente; socio: in tpSocio) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de DNI sea dni(socio)
   ----------------------------------------------------------------------------
   -- Post: Si el DNI de socio es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado temporalmente por "socio", hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(idCliente, tablaSocios, socio);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado "
         & cadena(socio));
   end modificarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarSocio(idCliente: in tpIdCliente; dni: in tpDNI) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de clave "dni"
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio de la biblioteca, dicho
   --       socio ha sido eliminado temporalmente de la biblioteca, hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(idCliente, tablaSocios, dni);
      put_line("Tarea" & integer'image(idCliente) & " ha eliminado socio "
         & tpDNI'image(dni));
   end eliminarSocio;
   ----------------------------------------------------------------------------


   --------------------
   -- Gestin de Libros
   --------------------
   ----------------------------------------------------------------------------
   procedure buscarLibro(idCliente: in tpIdCliente; isbn: in tpISBN;
         libro: out tpLibro; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el libro
   --       de clave "isbn" de la base de datos o lo tiene el proceso con
   --       identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, el valor del
   --       parmetro "libro" es igual a dicho dato y existe=true. En caso
   --       contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaLibros, isbn, idCliente, libro, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(libro));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpISBN'image(isbn));
      end if;
   end buscarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure insertarLibro(idCliente: in tpIdCliente; libro: in tpLibro) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el libro de la base de datos cuyo valor
   --       de ISBN sea isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: El libro se ha insertado temporalmente en la base de datos, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(idCliente, tablaLibros, libro);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado : "
         & cadena(libro));
   end insertarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure modificarLibro(idCliente: in tpIdCliente; libro: in tpLibro) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el socio de la base de datos cuyo valor
   --       de ISBN sea isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: Si el ISBN de "libro" es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado temporalmente por "libro", hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(idCliente, tablaLibros, libro);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado: "
         & cadena(libro));
   end modificarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure eliminarLibro(idCliente: in tpIdCliente; isbn: in tpISBN) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el libro de clave "isbn"
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, dicho
   --       libro ha sido eliminado temporalmente de la biblioteca, hasta que
   --       idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(idCliente, tablaLibros, isbn);
      put_line("Tarea" & integer'image(idCliente) & " ha borrado : "
         & tpISBN'image(isbn));
   end eliminarLibro;
   ----------------------------------------------------------------------------

   
   -----------------------
   -- Gestin de Prstamos
   -----------------------
   ----------------------------------------------------------------------------
   procedure buscarPrestamo(idCliente: in tpIdCliente; id: in tpIdPrestamo;
         prestamo: out tpPrestamo; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ningn proceso tiene el cerrojo necesario para operar con el
   --       prstamo de clave "id" de la base de datos o lo tiene el proceso
   --       con identificador idCliente
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, el valor
   --       del parmetro "prestamo" es igual a dicho dato y existe=true. En
   --       caso contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaPrestamos, id, idCliente, prestamo, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(prestamo));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpIdPrestamo'image(id));
      end if;
   end buscarPrestamo;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarPrestamo(idCliente: in integer; prestamo: in tpPrestamo)
         is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo de la base de datos cuyo
   --       identificador sea id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: El prstamo se ha insertado temporalmente en la base de datos,
   --       hasta que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(idCliente, tablaPrestamos, prestamo);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado: "
         & cadena(prestamo));
   end insertarPrestamo;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarPrestamo(idCliente: in integer; prestamo: in tpPrestamo)
      is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo de la base de datos cuyo
   --       identificador sea id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: Si el identificador de "prestamo" es la clave de algn prestamo de
   --       la biblioteca, dicho dato ha sido reemplazado temporalmente por
   --       "prestamo", hasta que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(idCliente, tablaPrestamos, prestamo);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado: "
         & cadena(prestamo));
   end modificarPrestamo;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarPrestamo(idCliente: in integer; id: in tpIdPrestamo) is
   ----------------------------------------------------------------------------
   -- Pre:  El proceso con identificador idCliente ha obtenido el cerrojo
   --       necesario para operar con el prstamo con identificador "id"
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, dicho
   --       prstamo ha sido eliminado temporalmente de la biblioteca, hasta
   --       que idCliente valide o cancele la transaccin
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(idCliente, tablaPrestamos, id);
      put_line("Tarea" & integer'image(idCliente) & " ha eliminado: "
         & tpIdPrestamo'image(id));
   end eliminarPrestamo;
   ----------------------------------------------------------------------------


   --------------------
   -- Consulta Cerrojos
   --------------------
   ----------------------------------------------------------------------------
   function idCerrojo(tabla: in tpTabla; clave: in tpClave)
      return tpIdCliente is     
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Ha devuelto el identificador de la tarea que tiene el cerrojo para
   --       operar con el dato de la tabla "tabla que tiene por clave "clave",
   --       o 0 si tal dato no existe o ninguna taera tiene el cerrojo
   ----------------------------------------------------------------------------
   begin
      return 0;
   end idCerrojo;
   ----------------------------------------------------------------------------

   ----------------
   -- Transacciones
   ----------------
   ----------------------------------------------------------------------------
   procedure iniciarTransaccion(tabla: in tpTabla; clave: in tpClave;
         idCliente: in tpIdCliente; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de la tabla "tabla",
   --       existe=true y el proceso cuyo 
   --       identificador es igual a idCliente ha adquirido el cerrojo para
   --       operar con l. En caso contrario, existe=false
   ----------------------------------------------------------------------------
   begin
      case tabla is     
         when SOCIOS =>
            iniciarTransaccion(idCliente, tablaSocios, clave, existe);
         when LIBROS =>
            iniciarTransaccion(idCliente, tablaLibros, clave, existe);
         when PRESTAMOS =>
            iniciarTransaccion(idCliente, tablaPrestamos, clave, existe);
      end case;
   end iniciarTransaccion;
   ----------------------------------------------------------------------------


   --------------------------
   -- finalizarTransaccion --
   --------------------------
   ----------------------------------------------------------------------------
   procedure validarTransaccion(idCliente:integer) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente han tomado carcter definitivo y se han
   --       liberado los cerrojos que poseyera
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin    
      validarTransaccion(idCliente, tablaSocios);      
      validarTransaccion(idCliente, tablaLibros);      
      validarTransaccion(idCliente, tablaPrestamos);     
      put("Tarea ");
      put(idCliente, 1);
      put_line(" ha validado transaccin");
   end validarTransaccion;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure cancelarTransaccion(idCliente:integer) is
   ----------------------------------------------------------------------------
   -- Pre:  TRUE
   ----------------------------------------------------------------------------
   -- Post: las operaciones que temporalmente haya hecho el cliente con
   --       identificador idCliente se han desechado y se han
   --       liberado los cerrojos que poseyera
   ----------------------------------------------------------------------------
   begin
      cancelarTransaccion(idCliente, tablaSocios);
      cancelarTransaccion(idCliente, tablaLibros);
      cancelarTransaccion(idCliente, tablaPrestamos);
      put("Tarea ");
      put(idCliente, 1);
      put_line(" cancela transaccin");
   end cancelarTransaccion;
   ----------------------------------------------------------------------------
   
end Biblioteca;

