/**
 * Cdigo de la clase TareaSimple de la 1. parte de la 3.
 * prctica de Programacin Concurrente
 * 
 * @author      Miguel ngel Latre Abada
 * @version     1, 5-2010
 */
package parte1;

/**
  * Clase que implementa la interfaz Runnable para escribir en
  * pantalla NUM_VECES veces un carcter (dgito del 0 al 9) que se
  * le indica al crearlo
  */
public class TareaSimple implements Runnable {

	/**
	  * Nmero de iteraciones de la escritura del dgito
	  */
	private static final int NUM_VECES = 10000;
	
	/**
	  * Identificador de la tarea y dgito que escribe en
	  * <code>System.out</code>. Est comprendido entre 0 y 9
	  */
	private int digitoParaEscribir;
	
	/**
	  * Referencia al objeto que cre esta tarea
	  */
	private Main main;
	
	/**
	  * Crea una nueva TareaSimple
	  *
	  * @param d El dgito que escribir cuando se ejecute su mtodo
	  *          <code>run()</code>. Debe estar comprendido entre 0 y 9
	  * @param main Referencia al objeto que cre esta tarea
	  */
	public TareaSimple(int d, Main main) {
		if (!(0 <= d) && (d<=9) ) {
			throw new IllegalArgumentException("d debe estar comprendido entre 0 y 9");
		}
		digitoParaEscribir = d;
		this.main = main;
	}
	
	/**
	  * Escribe NUM_VECES el dgito que se le ha indicado a este
	  * objeto al ser creado
	  */
	public void run() {
		for(int i = 0; i < NUM_VECES; i++) {
			escribir(digitoParaEscribir);
		}
	}				

	/**
	  * Escribe el dgito d en <code>System.out</code>. Si se trata del
	  * LONG_LINEA-simo carcter de la lnea, la finaliza
	  *
	  * @param d El dgito que se escribir en <code>System.out</code>
	  */
	public void escribir(int d) {
		System.out.print(d);
		main.incrementarNumEscritos();
		if (main.numEscritos() % Main.LONG_LINEA == 0) {
			System.out.println();
		}
	}		
}