package parte1;

/**
 * Cdigo de la clase Main de la 1. parte de la 3. prctica de
 * Programacin Concurrente
 * 
 * @author      Miguel ngel Latre Abada
 * @version     1, 5-2011
 */
public class Main {
   /**
     * Constante que define la longitud de las lneas escritas en
     * <code>System.out</code>
     */
   public static final int LONG_LINEA = 80;

   /**
     * Contador del nmero de caracteres (dgitos del 0 al 9)
     * escritos en <code>System.out</code>, para poder cambiar de
     * lnea cuando sea preciso
     */
   private int numEscritos = 0;

   /**
     * Crea 10 instancias TareaSimple y las activa
     */
   Main() {
      Thread[] t = new Thread[10];
      
      for (int i = 0; i < t.length; i++) {
         t[i] = new Thread(new TareaSimple(i, this));
         t[i].start();
      }
   }
   
   /**
     * Incrementa en una unidad el valor del nmero de caracteres
     * escritos en <code>System.out</code>
     */
   public void incrementarNumEscritos() {
      numEscritos = numEscritos + 1;
   }
   
   /**
     * Devuelve valor del nmero de caracteres escritos en
     * <code>System.out</code>
     *
     * @return el nmero de caracteres escritos en 
     * <code>System.out</code>
     */
   public int numEscritos() {
      return numEscritos;
   }

   /**
     * Crea un objeto de la clase <code>Main</code>
     */
   public static void main(String args[]) {
      new Main();
   }      
}