---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD Prestamo, para representar el
--              prstamo de un libro a un socio, con sus fechas de
--              prstamo y, si es aplicable, de devolucin
---------------------------------------------------------------------
with Ada.Calendar, Socio, Libro, Ada.Text_IO;
use  Ada.Calendar, Socio, Libro, Ada.Text_IO;

package Prestamo is
   
   type tpPrestamo is private;
   subtype tpIDPrestamo is long_long_integer range 1..1E18;
   
   ------------------------------------------------------------------
   function id(prestamo: tpPrestamo) return tpIDPrestamo; 
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un identificador numrico del prstamo
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function crear(codSocio: tpDNI; codLibro: tpISBN)
      return tpPrestamo;   
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado hoy y no devuelto
   ------------------------------------------------------------------   

   ------------------------------------------------------------------
   function crear(codSocio: tpDNI; codLibro: tpISBN;
      fechaPrestamo: Time) return tpPrestamo;   
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado en fechaPrestamo y no devuelto
   ------------------------------------------------------------------   

   ------------------------------------------------------------------
   function crear(codSocio: tpDNI; codLibro: tpISBN;
      fechaPrestamo, fechaDevolucion: Time) return tpPrestamo;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un dato que representa el prstamo al socio
   --       cuyo DNI es codSocio del libro cuyo ISBN es codLibro,
   --       prestado en fechaPrestamo y devuelto en fechaDevolucion
   ------------------------------------------------------------------   

   ------------------------------------------------------------------   
   function cadena(prestamo: tpPrestamo) return String;
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del prstamo
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   procedure leer(f: in file_type; prestamo: out tpPrestamo);
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las cuatro siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - un entero que representa un DNI
   --        - un entero que representa un ISBN
   --        - 1 o 0, que representa si el prestamo se ha devuelto o
   --          no, respectivamente
   --        - 6 enteros, separados por espacios, que representan, en
   --          este orden, da, mes y ao de la fecha de prstamo y
   --          da, mes y ao de la fecha de devolucin (incluso si
   --          no se ha devuelto)
   ------------------------------------------------------------------
   -- Post: Ha ledo las cuatro siguientes lneas de f y el valor del
   --       parmetro prestamo ha sido inicializado con los datos
   --       ledos
   ------------------------------------------------------------------   
private
   type tpPrestamo is record
      codSocio: tpDNI;
      codLibro: tpISBN;
      devuelto: boolean := false;
      fechaPrestamo, fechaDevolucion: time;
   end record;
end Prestamo;

