------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD ListaTransaccional
------------------------------------------------------------------------------
with Unchecked_Deallocation;
package body Lista is

   ---------------------------------------------------------------------------
   function buscar(l: in tpLista; claveBusqueda: in tpClave)
         return tpPtInfo is            
   ---------------------------------------------------------------------------
   -- Pre:  TRUE
   ---------------------------------------------------------------------------
   -- Post: si hay en la lista un elemento d tal que clave(d)=clave, 
   --       ha devuelto la posicin de ese dato d;
   --       en caso contrario, devuelve null
   ---------------------------------------------------------------------------
      puntero: tpPtInfo;
   begin
      puntero := l.primero;
      while puntero /= null and then clave(puntero.dato) /= claveBusqueda loop
         puntero := puntero.siguiente;
      end loop;
      -- puntero = null or else clave(puntero.dato) = claveBusqueda
      return puntero;
   end buscar;
   ---------------------------------------------------------------------------

   ---------------------------------------------------------------------------
   procedure insertarDato(l: in out tpLista; dato: in tpDato) is
   ---------------------------------------------------------------------------
   -- Pre:  El proceso que desea insertar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ---------------------------------------------------------------------------
   -- Post: dato se ha insertado en l
   ---------------------------------------------------------------------------
      puntero: tpPtInfo;
   begin
     if l.primero = null then
         l.primero := new tpInfo;
         puntero := l.primero;
      else
         puntero := l.primero;
         while puntero.siguiente /= null loop
            puntero := puntero.siguiente;
         end loop;
         puntero.siguiente := new tpInfo;
         puntero.siguiente.anterior := puntero;
         puntero := puntero.siguiente;
      end if;
      puntero.dato := dato;
   end insertarDato;
   ---------------------------------------------------------------------------

   procedure liberar is new Unchecked_Deallocation(tpInfo, tpPtInfo);
	
   ---------------------------------------------------------------------------
   procedure eliminarDato(l: in out tpLista; clave: in tpClave) is
   ---------------------------------------------------------------------------
   -- Pre:  El proceso que desea eliminar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave "clave"
   ---------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, dicho dato
   --       ha sido eliminado de l,
   ---------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave);
   begin
      if puntero /= null then
         if puntero.siguiente /= null then
            puntero.siguiente.anterior := puntero.anterior;
         end if;
         if puntero.anterior /= null then
            puntero.anterior.siguiente := puntero.siguiente;
         else
            l.primero := null;
         end if;
         liberar(puntero);
      end if;
   end eliminarDato;
  ----------------------------------------------------------------------------
	
   ---------------------------------------------------------------------------
   procedure modificarDato(l: in out tpLista; dato: in tpDato) is
   ---------------------------------------------------------------------------
   -- Pre:  El proceso que desea modificar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ---------------------------------------------------------------------------
   -- Post: Si clave(dato) es la clave de algn dato de l, dicho dato
   --       ha sido reemplazado por "dato"
   ---------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave(dato));
   begin
      if puntero /= null then
         puntero.dato := dato;
      end if;
   end modificarDato;
   ---------------------------------------------------------------------------
   
   ---------------------------------------------------------------------------
   procedure buscar(l: in tpLista; clave: in tpClave;
                    dato: out tpDato; encontrado: out boolean) is
   ---------------------------------------------------------------------------
   -- Pre:  Ningn otro proceso tiene el cerrojo necesario para operar con el
   --       dato de clave "clave"
   ---------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato y encontrado=true. En caso contrario, 
   --       encontrado=false
   ---------------------------------------------------------------------------
      puntero: tpPtInfo := buscar(l, clave);
   begin
      if puntero /= null then
         dato := puntero.dato;
         encontrado := true;
      else
         encontrado := false;
      end if;
   end buscar;
   ---------------------------------------------------------------------------
             
end Lista;
------------------------------------------------------------------------------

