------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Programa que simula un conjunto de operaciones sobre una base
--              datos para una biblioteca especificadas en un fichero de texto
------------------------------------------------------------------------------
with Biblioteca, Socio, Libro, Prestamo, ProcesadorGenerico;
use  Biblioteca, Socio, Libro, Prestamo, ProcesadorGenerico;
with Ada.Exceptions, Ada.Calendar;
use  Ada.Exceptions, Ada.Calendar;
with Ada.Text_IO, Ada.Float_Text_IO;
use  Ada.Text_IO, Ada.Float_Text_IO;

------------------------------------------------------------------------------
-- Pre:  Existe un fichero denominado "traza.txt" que especifica un conjunto
--       de operaciones sobre una base datos para una biblioteca
------------------------------------------------------------------------------
-- Post: Ha ejecutado las operaciones especificadas en el fichero y ha
--       informado del tiempo total que le ha costado realizarlas
------------------------------------------------------------------------------
procedure Simulacion is

   ---------------------------------------------------------------------------
   -- Pre:  f est en modo lectura y asociado con un fichero que especifica un
   --       conjunto de operaciones sobre una base datos para una biblioteca
   ---------------------------------------------------------------------------
   -- Post: Ha ejecutado las operaciones especificadas en el fichero
   ---------------------------------------------------------------------------
   procedure simularTraza(idCliente: in integer; f: in file_type) is
 
      procedure procesarSocio is new procesar(tpSocio, dni, leer, 
            Biblioteca.buscarSocio, Biblioteca.insertarSocio,
            Biblioteca.modificarSocio, Biblioteca.eliminarSocio);

      procedure procesarLibro is new procesar(tpLibro, isbn, leer, 
            Biblioteca.buscarLibro, Biblioteca.insertarLibro,
            Biblioteca.modificarLibro, Biblioteca.eliminarLibro);

      procedure procesarPrestamo is new procesar(tpPrestamo, id, leer, 
            Biblioteca.buscarPrestamo, Biblioteca.insertarPrestamo,
            Biblioteca.modificarPrestamo, Biblioteca.eliminarPrestamo);

      operacion: string(1..2);
   begin
      while not end_of_file(f) loop
         get(f, operacion); skip_line(f);
         if operacion(2) = 'S' then
            procesarSocio(operacion(1), f, SOCIOS, idCliente);
         elsif operacion(2) = 'L' then
            procesarLibro(operacion(1), f, LIBROS, idCliente);
         elsif operacion(2) = 'P' then
            procesarPrestamo(operacion(1), f, PRESTAMOS, idCliente);
         end if;
      end loop;
   end simularTraza;
   
   f: file_type;
   inicio, fin: time;
begin
   inicio := clock;

   begin
      open(f, IN_FILE, "traza-1.txt");
      simularTraza(1, f);
      close(f);
   exception
      when ex: others =>
         put_line(exception_name(ex)); put_line(exception_message(ex));
   end;
   
   fin := clock;
   new_line;
   put("Tiempo total de simulacin: ");
   put(float(fin-inicio), 1, 2, 0);
   new_line;
end Simulacion;

