------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Implementacin del procedimento genrico que procesa
--              operaciones de una determinada entidad sobre la base de datos
------------------------------------------------------------------------------
with Biblioteca, Ada.Text_IO, Ada.Numerics.Float_Random;
use  Biblioteca, Ada.Text_IO, Ada.Numerics.Float_Random;

package body ProcesadorGenerico is

   package long_long_integer_io is new integer_io(long_long_integer);
   use long_long_integer_io;
   
   g: Generator;
   
   -------------------------------------------------------------------------
   procedure procesar(orden: in character; f: in file_type;
      tabla: tpTabla; idCliente: tpIdCliente) is
   -------------------------------------------------------------------------
   -- Pre:  orden pertenece a {'I', 'E', 'M', 'C'}
   --       f asociado con un fichero de texto con el formato de traza de 
   --       operaciones, en modo lectura y en la lnea siguiente a una
   --       orden
   -------------------------------------------------------------------------
   -- Post: ha ledo de f el resto de la operacin descrita y la lnea en
   --       blanco que la separa de la siguiente operacin.
   --       Ha procesado la operacin, insertanto un nuevo dato, o 
   --       eliminndolo, o modificndolo o consultndolo, en funcin del
   --       valor del parmetro orden ('I', 'E', 'M', 'C', respectivamente),
   --       esperando un tiempo aleatorio de no ms de 0.01 segundos entre
   --       cada operacin
   -------------------------------------------------------------------------
      dato: tpDato;
      existe: boolean;
      laClave: tpClave;
      escritor: tpIdCliente;
   begin
      if orden = 'I' or orden = 'M' then
         leer(f, dato); laClave := clave(dato);
      else
         get(f, laClave); skip_line(f);
      end if;

      if orden = 'C' then
         buscar(idCliente, laClave, dato, existe);
      else   
         if orden = 'I' then
            insertar(idCliente, dato);
         elsif orden = 'M' then 
            modificar(idCliente, dato);
         elsif orden = 'E' then
            eliminar(idCliente, laClave);
         end if;
      end if;
      delay duration(0.01 * random(g));
   end procesar;
   -------------------------------------------------------------------------
 
end ProcesadorGenerico;

