-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD Lista
-------------------------------------------------------------------------------

generic
   type tpDato is private;
   type tpClave is private;
   with function clave(d: in tpDato) return tpClave;
package Lista is
   type tpLista is limited private;   
	
   ----------------------------------------------------------------------------
   procedure insertarDato(l: in out tpLista; dato: in tpDato);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso que desea insertar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: dato se ha insertado en l
   ----------------------------------------------------------------------------
	
   ----------------------------------------------------------------------------
   procedure eliminarDato(l: in out tpLista; clave: in tpClave);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso que desea eliminar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave "clave"
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, dicho dato
   --       ha sido eliminado de l,
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarDato(l: in out tpLista;
      dato: in tpDato);
   ----------------------------------------------------------------------------
   -- Pre:  El proceso que desea modificar ha obtenido el cerrojo
   --       necesario para operar con el dato de clave clave(dato)
   ----------------------------------------------------------------------------
   -- Post: Si clave(dato) es la clave de algn dato de l, dicho dato
   --       ha sido reemplazado por "dato"
   ----------------------------------------------------------------------------
  
   ----------------------------------------------------------------------------
   procedure buscar(l: in tpLista; clave: in tpClave; 
                    dato: out tpDato; encontrado: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ningn otro proceso tiene el cerrojo necesario para operar con el
   --       dato de clave "clave"
   ----------------------------------------------------------------------------
   -- Post: Si "clave" es la clave de algn dato de l, el valor del parmetro
   --       "dato" es igual a dicho dato y encontrado=true. En caso contrario, 
   --       encontrado=false
   ----------------------------------------------------------------------------
   
private

   type tpInfo;
   type tpPtInfo is access tpInfo;

   type tpInfo is record
      dato: tpDato;
      siguiente, anterior: tpPtInfo := null;
   end record;
	
   type tpLista is record
      primero:  tpPtInfo;
   end record;
end Lista;