-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD Libro
-------------------------------------------------------------------------------
with ada.strings;
use  ada.strings;

package body Libro is

   ------------------------------------------------------------------
   function isbn(libro: in tpLibro) return tpISBN is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto el DNI del socio
   ------------------------------------------------------------------
   begin
      return libro.ISBN;
   end isbn;
   ------------------------------------------------------------------

   ------------------------------------------------------------------
   function crear(titulo, autor: String; isbn: tpISBN) return tpLibro is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto un nuevo libro creado a travs de los valores
   --       de los parmetros
   ------------------------------------------------------------------
      l: tpLibro;
   begin
      l.titulo := to_bounded_string(titulo, RIGHT);
      l.autor := to_bounded_string(autor, RIGHT);
      l.isbn := isbn;
      return l;
   end crear;
   ------------------------------------------------------------------
   
   ------------------------------------------------------------------
   function cadena(libro: tpLibro) return String is
   ------------------------------------------------------------------
   -- Pre:  TRUE
   ------------------------------------------------------------------
   -- Post: Ha devuelto una cadena con una representacin textual de
   --       los datos del libro
   ------------------------------------------------------------------
   begin
      return to_string(libro.titulo) & " de " & to_string(libro.autor) & " ("
         & tpISBN'image(libro.isbn) & ')';
   end cadena;
   ------------------------------------------------------------------

   package tpISBN_io is new integer_io(tpISBN);
   use tpISBN_io;

   ------------------------------------------------------------------
   procedure leer(f: in file_type; libro: out tpLibro) is
   ------------------------------------------------------------------
   -- Pre:  f est en modo lectura, asociado con un fichero de texto
   --       y en las tres siguientes lneas pendientes de leer hay,
   --       exclusivamente:
   --        - una cadena de caracteres que representa un ttulo
   --        - una cadena de caracteres que representa un autor
   --        - un entero que representa un ISBN  
   ------------------------------------------------------------------
   -- Post: Ha ledo las tres siguientes lneas de f y el valor del
   --       parmetro libro ha sido inicializado con los datos ledos
   ------------------------------------------------------------------
      titulo, autor: string(1..250);
      longTitulo, longAutor: natural;
      isbn: tpISBN;
   begin
      get_line(f, titulo, longTitulo);
      get_line(f, autor, longAutor);
      get(f, isbn); skip_line(f, 2);
      
      libro := crear(titulo(1..longTitulo), autor(1..longAutor), isbn);
   end leer;
   ------------------------------------------------------------------

end Libro;