-------------------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD Biblioteca
-------------------------------------------------------------------------------
with Lista, Libro, Socio, Prestamo;
use  Libro, Socio, Prestamo;

-------------------------------------------------------------------------------
package Biblioteca is
   
   MAX_CLIENTES: constant positive := 8;
   subtype tpIDCliente is positive range 1..MAX_CLIENTES;
   subtype tpClave is long_long_integer;
   
   type tpTabla is (SOCIOS, LIBROS, PRESTAMOS);

   ----------------------------------------------------------------------------
   procedure buscarSocio(idCliente: in tpIdCliente; dni: in tpDNI; 
                         socio: out tpSocio; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de clave "dni" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio, el valor del parmetro
   --       "socio" es igual a dicho dato y existe=true. En caso contrario, 
   --       existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarSocio(idCliente: in tpIdCliente; socio: in tpSocio);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de la base de datos cuyo valor de DNI es dni(socio)
   ----------------------------------------------------------------------------
   -- Post: El socio se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarSocio(idCliente: in tpIdCliente; socio: in tpSocio);   
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de la base de datos cuyo valor de DNI es dni(socio)
   ----------------------------------------------------------------------------
   -- Post: Si el DNI de socio es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado por "socio"
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarSocio(idCliente: in tpIdCliente; dni: in tpDNI);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       el socio de clave "dni"
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio de la biblioteca, dicho
   --       socio ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure buscarLibro(idCliente: in tpIdCliente; isbn: in tpISBN;
      libro: out tpLibro; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de clave "isbn" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, el valor del
   --       parmetro "libro" es igual a dicho dato y existe=true. En caso
   --       contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarLibro(idCliente: in tpIdCliente; libro: in tpLibro);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de la base de datos cuyo valor de ISBN es isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: El libro se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarLibro(idCliente: in tpIdCliente; libro: in tpLibro);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de la base de datos cuyo valor de ISBN es isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: Si el ISBN de "libro" es la clave de algn libro de la biblioteca,
   --       dicho dato ha sido reemplazado por "libro"
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarLibro(idCliente: in tpIdCliente; isbn: in tpISBN);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de clave "isbn"
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, dicho
   --       libro ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure buscarPrestamo(idCliente: in tpIdCliente; id: in tpIdPrestamo;
         prestamo: out tpPrestamo; existe: out boolean);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de clave "id" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, el valor
   --       del parmetro "prestamo" es igual a dicho dato y existe=true. En
   --       caso contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarPrestamo(idCliente: in tpIdCliente;
                              prestamo: in tpPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de la base de datos cuyo
   --       identificador es id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: El prstamo se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarPrestamo(idCliente: in tpIdCliente; prestamo: in tpPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de la base de datos cuyo
   --       identificador es id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: Si el identificador de "prestamo" es la clave de algn prestamo de
   --       la biblioteca, dicho dato ha sido reemplazado por "prestamo",
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarPrestamo(idCliente: in tpIdCliente; id: in tpIdPrestamo);
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo con identificador "id"
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, dicho
   --       prstamo ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------


private
   package listaSocios is new Lista(tpSocio, tpDNI, dni);
   package listaLibros is new Lista(tpLibro, tpISBN, isbn);
   package listaPrestamos is new Lista(tpPrestamo, tpIDPrestamo, id);
   
   tablaSocios: listaSocios.tpLista;
   tablaLibros: listaLibros.tpLista;
   tablaPrestamos: listaPrestamos.tpLista;
end Biblioteca;
-------------------------------------------------------------------------------
