---------------------------------------------------------------------
-- AUTOR: Miguel ngel LATRE
-- PROYECTO: Prctica 2 de Programacin Concurrente. Curso 2011-12
-- FECHA LTIMA REVISION: marzo-2012
-- DESCRIPCIN: Especificacin del TAD Biblioteca
---------------------------------------------------------------------
with ada.text_io;
use  ada.text_io;

package body Biblioteca is
   
   use listaSocios, listaLibros, listaPrestamos;
   
   
   -----------------------
   -- Gestin de socios --
   -----------------------
   ----------------------------------------------------------------------------
   procedure buscarSocio(idCliente: in tpIdCliente; dni: in tpDNI;
      socio: out tpSocio; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de clave "dni" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio, el valor del parmetro
   --       "socio" es igual a dicho dato y existe=true. En caso contrario, 
   --       existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaSocios, dni, socio, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(socio));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpDNI'image(dni));
      end if;
   end buscarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarSocio(idCliente: in tpIdCliente; socio: in tpSocio) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de la base de datos cuyo valor de DNI es dni(socio)
   ----------------------------------------------------------------------------
   -- Post: El socio se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(tablaSocios, socio);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado "
         & cadena(socio));
   end insertarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarSocio(idCliente: in tpIdCliente; socio: in tpSocio) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       socio de la base de datos cuyo valor de DNI es dni(socio)
   ----------------------------------------------------------------------------
   -- Post: Si el DNI de socio es la clave de algn socio de la biblioteca,
   --       dicho dato ha sido reemplazado por "socio"
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(tablaSocios, socio);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado "
         & cadena(socio));
   end modificarSocio;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure eliminarSocio(idCliente: in tpIdCliente; dni: in tpDNI) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       el socio de clave "dni"
   ----------------------------------------------------------------------------
   -- Post: Si "dni" es la clave de algn socio de la biblioteca, dicho
   --       socio ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(tablaSocios, dni);
      put_line("Tarea" & integer'image(idCliente) & " ha eliminado socio "
         & tpDNI'image(dni));
   end eliminarSocio;
   ----------------------------------------------------------------------------


   -----------------------
   -- Gestin de Libros --
   -----------------------
   ----------------------------------------------------------------------------
   procedure buscarLibro(idCliente: in tpIdCliente; isbn: in tpISBN;
         libro: out tpLibro; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de clave "isbn" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, el valor del
   --       parmetro "libro" es igual a dicho dato y existe=true. En caso
   --       contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaLibros, isbn, libro, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(libro));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpISBN'image(isbn));
      end if;
   end buscarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure insertarLibro(idCliente: in tpIdCliente; libro: in tpLibro) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de la base de datos cuyo valor de ISBN es isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: El libro se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(tablaLibros, libro);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado : "
         & cadena(libro));
   end insertarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure modificarLibro(idCliente: in tpIdCliente; libro: in tpLibro) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de la base de datos cuyo valor de ISBN es isbn(libro)
   ----------------------------------------------------------------------------
   -- Post: Si el ISBN de "libro" es la clave de algn libro de la biblioteca,
   --       dicho dato ha sido reemplazado por "libro"
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(tablaLibros, libro);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado: "
         & cadena(libro));
   end modificarLibro;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure eliminarLibro(idCliente: in tpIdCliente; isbn: in tpISBN) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       libro de clave "isbn"
   ----------------------------------------------------------------------------
   -- Post: Si "isbn" es la clave de algn libro de la biblioteca, dicho
   --       libro ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(tablaLibros, isbn);
      put_line("Tarea" & integer'image(idCliente) & " ha borrado : "
         & tpISBN'image(isbn));
   end eliminarLibro;
   ----------------------------------------------------------------------------

   
   --------------------------
   -- Gestin de Prstamos --
   --------------------------
   ----------------------------------------------------------------------------
   procedure buscarPrestamo(idCliente: in tpIdCliente; id: in tpIdPrestamo;
         prestamo: out tpPrestamo; existe: out boolean) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de clave "id" de la base de datos
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, el valor
   --       del parmetro "prestamo" es igual a dicho dato y existe=true. En
   --       caso contrario, existe=false
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      buscar(tablaPrestamos, id, prestamo, existe);
      if existe then
         put_line("Tarea" & integer'image(idCliente) & " ha encontrado"
            & cadena(prestamo));
      else 
         put_line("Tarea" & integer'image(idCliente)
            & " no ha encontrado socio" & tpIdPrestamo'image(id));
      end if;
   end buscarPrestamo;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure insertarPrestamo(idCliente: in tpIdCliente;
                              prestamo: in tpPrestamo) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de la base de datos cuyo
   --       identificador es id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: El prstamo se ha insertado en la base de datos
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      insertarDato(tablaPrestamos, prestamo);
      put_line("Tarea" & integer'image(idCliente) & " ha insertado: "
         & cadena(prestamo));
   end insertarPrestamo;
   ----------------------------------------------------------------------------

   ----------------------------------------------------------------------------
   procedure modificarPrestamo(idCliente: in tpIdCliente;
                               prestamo: in tpPrestamo) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo de la base de datos cuyo
   --       identificador es id(prestamo)
   ----------------------------------------------------------------------------
   -- Post: Si el identificador de "prestamo" es la clave de algn prestamo de
   --       la biblioteca, dicho dato ha sido reemplazado por "prestamo",
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      modificarDato(tablaPrestamos, prestamo);
      put_line("Tarea" & integer'image(idCliente) & " ha modificado: "
         & cadena(prestamo));
   end modificarPrestamo;
   ----------------------------------------------------------------------------
   
   ----------------------------------------------------------------------------
   procedure eliminarPrestamo(idCliente: in tpIdCliente;
                              id: in tpIdPrestamo) is
   ----------------------------------------------------------------------------
   -- Pre:  Ninguna otra tarea est escribiendo el registro correspondiente al
   --       prstamo con identificador "id"
   ----------------------------------------------------------------------------
   -- Post: Si "id" es la clave de algn prstamo de la biblioteca, dicho
   --       prstamo ha sido eliminado de la biblioteca
   --       Ha escrito en pantalla un mensaje indicando la operacin realizada
   ----------------------------------------------------------------------------
   begin
      eliminarDato(tablaPrestamos, id);
      put_line("Tarea" & integer'image(idCliente) & " ha eliminado: "
         & tpIdPrestamo'image(id));
   end eliminarPrestamo;
   ----------------------------------------------------------------------------
   
end Biblioteca;

