/*
 * Decompiled with CFR 0.152.
 */
package uci.graph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.graph.GraphEvent;
import uci.graph.GraphListener;
import uci.graph.MutableGraphModel;

public abstract class MutableGraphSupport
implements MutableGraphModel,
Serializable {
    protected Vector _graphListeners;

    public Vector getGraphListeners() {
        return this._graphListeners;
    }

    public boolean canConnect(Object fromPort, Object toPort, Class edgeClass) {
        return this.canConnect(fromPort, toPort);
    }

    public Object connect(Object fromPort, Object toPort, Class edgeClass) {
        return this.connect(fromPort, toPort);
    }

    public boolean containsNode(Object node) {
        Vector nodes = this.getNodes();
        return nodes.contains(node);
    }

    public boolean containsEdge(Object edge) {
        Vector edges = this.getEdges();
        return edges.contains(edge);
    }

    public boolean containsNodePort(Object port) {
        Vector nodes = this.getNodes();
        if (nodes == null) {
            return false;
        }
        Enumeration nodeEnum = nodes.elements();
        while (nodeEnum.hasMoreElements()) {
            Object node = nodeEnum.nextElement();
            Vector ports = this.getPorts(node);
            if (ports == null || !ports.contains(port)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEdgePort(Object port) {
        Vector edges = this.getNodes();
        if (edges == null) {
            return false;
        }
        Enumeration edgeEnum = edges.elements();
        while (edgeEnum.hasMoreElements()) {
            Object edge = edgeEnum.nextElement();
            Vector ports = this.getPorts(edge);
            if (ports == null || !ports.contains(port)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPort(Object port) {
        return this.containsNodePort(port) || this.containsEdgePort(port);
    }

    public void addGraphEventListener(GraphListener listener2) {
        if (this._graphListeners == null) {
            this._graphListeners = new Vector();
        }
        this._graphListeners.addElement(listener2);
    }

    public void removeGraphEventListener(GraphListener listener2) {
        if (this._graphListeners == null) {
            return;
        }
        this._graphListeners.removeElement(listener2);
    }

    public void fireNodeAdded(Object node) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, node);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.nodeAdded(ge);
        }
    }

    public void fireNodeRemoved(Object node) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, node);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.nodeRemoved(ge);
        }
    }

    public void fireEdgeAdded(Object edge) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, edge);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.edgeAdded(ge);
        }
    }

    public void fireEdgeRemoved(Object edge) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, edge);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.edgeRemoved(ge);
        }
    }

    public void fireGraphChanged() {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent ge = new GraphEvent(this, null);
        Enumeration listeners = this._graphListeners.elements();
        while (listeners.hasMoreElements()) {
            GraphListener listen = (GraphListener)listeners.nextElement();
            listen.graphChanged(ge);
        }
    }

    public abstract Object connect(Object var1, Object var2);

    public abstract boolean canConnect(Object var1, Object var2);

    public abstract void removeEdge(Object var1);

    public abstract void addEdge(Object var1);

    public abstract void addNode(Object var1);

    public abstract void removeNode(Object var1);

    public abstract boolean canAddEdge(Object var1);

    public abstract boolean canAddNode(Object var1);

    public abstract Object getDestPort(Object var1);

    public abstract Object getSourcePort(Object var1);

    public abstract Vector getOutEdges(Object var1);

    public abstract Vector getInEdges(Object var1);

    public abstract Object getOwner(Object var1);

    public abstract Vector getPorts(Object var1);

    public abstract Vector getEdges();

    public abstract Vector getNodes();
}

