/*
 * Decompiled with CFR 0.152.
 */
package uci.gef.demo;

import java.awt.Color;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.FigImage;
import uci.gef.FigNode;
import uci.gef.FigRRect;
import uci.gef.FigRect;
import uci.gef.Layer;
import uci.gef.NetNode;
import uci.gef.demo.PortData;
import uci.gef.demo.PortPower;

public class NodeCPU
extends NetNode
implements Serializable {
    public static final String pMEGS_OF_RAM = "Megs Of RAM";
    public static final String pBUS_SPEED_MHZ = "Bus Speed Mhz";
    public static final String pCPU_SPEED_MHZ = "CPU Speed Mhz";
    public static final String pHAS_CD_ROM = "Has CD ROM";
    public static final String pOWNER_INFO = "Owner";
    protected int _megsOfRAM = 16;
    protected int _busSpeedMHz = 25;
    protected int _cpuSpeedMHz = 100;
    protected boolean _hasCDROM = true;
    protected String _ownerInfo = "Your Name Here\nYour Company\nYour Address Line1\nYour Address Line 2";
    PortPower powerPort;
    PortData dataPort;

    public void initialize(Hashtable args) {
        this.powerPort = new PortPower(this, 2);
        this.addPort(this.powerPort);
        this.dataPort = new PortData(this);
        this.addPort(this.dataPort);
    }

    public int getMegsOfRAM() {
        return this._megsOfRAM;
    }

    public int getBusSpeedMHz() {
        return this._busSpeedMHz;
    }

    public int getCPUSpeedMhz() {
        return this._cpuSpeedMHz;
    }

    public boolean getHasCDROM() {
        return this._hasCDROM;
    }

    public String getOwnerInfo() {
        return this._ownerInfo;
    }

    public void setMegsOfRAM(int m) {
        if (m % 8 == 0) {
            this._megsOfRAM = m;
        }
    }

    public void setBusSpeedMHz(int b) {
        if (b % 25 == 0 || b % 33 == 0) {
            this._busSpeedMHz = b;
        }
    }

    public void setCPUSpeedMhz(int c) {
        if (c == 25 || c == 33 || c == 50 || c == 66 || c == 75 || c == 90 || c == 100 || c == 120 || c == 133 || c == 150 || c == 166 || c == 200 || c == 233) {
            this._cpuSpeedMHz = c;
        }
    }

    public void setHasCDROM(boolean r) {
        this._hasCDROM = r;
    }

    public void setOwnerInfo(String oi) {
        this._ownerInfo = oi;
    }

    public FigNode makePresentation(Layer lay) {
        URL imageURL = null;
        try {
            imageURL = new URL("http://www.ics.uci.edu/~jrobbins/images/cpu.gif");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        FigImage obj1 = new FigImage(0, 0, imageURL);
        int imageWidth = obj1.getWidth();
        FigRect obj2 = new FigRect(2, -7, 14, 14, Color.black, Color.white);
        FigRRect obj3 = new FigRRect(imageWidth - 4, 10, 8, 15, Color.black, Color.black);
        obj3.setCornerRadius(3);
        Vector<Fig> temp_list = new Vector<Fig>();
        temp_list.addElement(obj1);
        temp_list.addElement(obj2);
        temp_list.addElement(obj3);
        FigNode fn = new FigNode(this, temp_list);
        fn.bindPort(this.powerPort, obj2);
        fn.bindPort(this.dataPort, obj3);
        return fn;
    }

    static {
        pMEGS_OF_RAM = pMEGS_OF_RAM;
        pBUS_SPEED_MHZ = pBUS_SPEED_MHZ;
        pCPU_SPEED_MHZ = pCPU_SPEED_MHZ;
        pHAS_CD_ROM = pHAS_CD_ROM;
        pOWNER_INFO = pOWNER_INFO;
        Vector<Integer> possibleCPUSpeeds = new Vector<Integer>();
        possibleCPUSpeeds.addElement(new Integer(25));
        possibleCPUSpeeds.addElement(new Integer(33));
        possibleCPUSpeeds.addElement(new Integer(66));
        possibleCPUSpeeds.addElement(new Integer(75));
        possibleCPUSpeeds.addElement(new Integer(90));
        possibleCPUSpeeds.addElement(new Integer(100));
        possibleCPUSpeeds.addElement(new Integer(120));
        possibleCPUSpeeds.addElement(new Integer(133));
        possibleCPUSpeeds.addElement(new Integer(150));
        possibleCPUSpeeds.addElement(new Integer(166));
        possibleCPUSpeeds.addElement(new Integer(200));
        possibleCPUSpeeds.addElement(new Integer(233));
    }
}

