/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Handle;
import uci.gef.Layer;

public abstract class Selection
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final int HAND_SIZE = 6;
    public static final int BORDER_WIDTH = 4;
    protected Fig _content;

    public Selection(Fig f) {
        if (f == null) {
            throw new NullPointerException();
        }
        this._content = f;
    }

    public Fig getContent() {
        return this._content;
    }

    public void setcontent(Fig f) {
        this._content = f;
    }

    public boolean getLocked() {
        return this.getContent().getLocked();
    }

    public boolean contains(Fig f) {
        return f == this._content;
    }

    public void print(Graphics g) {
    }

    public abstract void paint(Graphics var1);

    public void startTrans() {
        this.getContent().startTrans();
    }

    public void endTrans() {
        this.getContent().endTrans();
    }

    public Point getLocation() {
        return this._content.getLocation();
    }

    public void damage() {
        this._content.damage();
    }

    public final boolean contains(Point pnt) {
        return this.contains(pnt.x, pnt.y);
    }

    public boolean contains(int x, int y) {
        return this._content.contains(x, y) || this.hitHandle(x, y, 0, 0) != -1;
    }

    public boolean hit(Rectangle r) {
        return this._content.hit(r) || this.hitHandle(r) != -1;
    }

    public abstract int hitHandle(Rectangle var1);

    public final int hitHandle(int x, int y, int w, int h) {
        return this.hitHandle(new Rectangle(x, y, w, h));
    }

    public void reorder(int func, Layer lay) {
        lay.reorder(this._content, func);
    }

    public void align(int direction) {
    }

    public void align(Rectangle r, int direction, Editor ed) {
        this._content.align(r, direction, ed);
    }

    public void translate(int dx, int dy) {
        this._content.translate(dx, dy);
    }

    public Rectangle getBounds() {
        return new Rectangle(this._content.getX() - 3, this._content.getY() - 3, this._content.getWidth() + 6, this._content.getHeight() + 6);
    }

    public void stuffBounds(Rectangle r) {
        r.setBounds(this._content.getX() - 3, this._content.getY() - 3, this._content.getWidth() + 6, this._content.getHeight() + 6);
    }

    public void delete() {
        this._content.delete();
    }

    public void dispose() {
        this._content.dispose();
    }

    public abstract void dragHandle(int var1, int var2, int var3, int var4, Handle var5);

    public Rectangle getContentBounds() {
        return this._content.getBounds();
    }

    public void keyTyped(KeyEvent ke) {
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyTyped(ke);
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyPressed(ke);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void mouseMoved(MouseEvent me) {
        if (this._content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this._content)).mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this._content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this._content)).mouseDragged(me);
        }
    }

    public void mousePressed(MouseEvent me) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseReleased(me);
        }
    }

    public void mouseClicked(MouseEvent me) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseClicked(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseExited(me);
        }
    }

    static {
        HAND_SIZE = 6;
        BORDER_WIDTH = 4;
    }
}

