/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Selection;

public class RedrawManager
implements Runnable {
    private final int MAX_NUM_RECTS = 10;
    private Rectangle[] _rects = new Rectangle[10];
    private int _nRects = 0;
    private Editor _ed;
    private Thread _repairThread;
    private long deadline = 0L;
    private static long _timeDelay = 25L;
    private static String LOCK = new String("LOCK");
    private static int _lockLevel = 0;
    protected Image image64x64;
    protected Image image256x64;
    protected Image image64x256;
    protected Image image256x256;
    protected Image image64x512;
    protected Image image512x64;
    protected Image image512x512;

    public RedrawManager(Editor ed) {
        for (int i = 0; i < 10; ++i) {
            this._rects[i] = new Rectangle();
        }
        this._ed = ed;
        this._repairThread = new Thread((Runnable)this, "RepairThread");
        this._repairThread.start();
    }

    public static long getTimeBetweenRepairs() {
        return _timeDelay;
    }

    public static void setTimeBetweenRepairs(long t) {
        _timeDelay = t;
    }

    public static void moreRepairs() {
        if ((_timeDelay -= (long)5) < (long)10) {
            _timeDelay = 10L;
        }
    }

    public static void fewerRepairs() {
        if ((_timeDelay += (long)50) > (long)2000) {
            _timeDelay = 2000L;
        }
    }

    public static void setFramesPerSecond(float fps) {
        if ((double)fps > 100.0 || (double)fps < 0.5) {
            return;
        }
        int _timeDelay = (int)((float)1000 / fps);
    }

    public static float getFramesPerSecond() {
        return (float)(1000.0 / (double)_timeDelay);
    }

    private void removeAllElements() {
        this._nRects = 0;
    }

    public boolean pendingDamage() {
        return this._nRects != 0;
    }

    public void add(Rectangle r) {
        if (r.isEmpty()) {
            return;
        }
        String string = LOCK;
        synchronized (string) {
            if (!this.merge(r)) {
                this._rects[this._nRects++].setBounds(r.x, r.y, r.width, r.height);
            }
            if (this._nRects == 10) {
                this.forceMerge();
            }
            if (this.deadline == (long)0) {
                this.deadline = System.currentTimeMillis() + _timeDelay;
            }
        }
    }

    public void add(Fig f) {
        String string = LOCK;
        synchronized (string) {
            f.stuffBounds(this._rects[this._nRects]);
            if (!this.merge(this._rects[this._nRects])) {
                ++this._nRects;
            }
            if (this._nRects == 10) {
                this.forceMerge();
            }
            if (this.deadline == (long)0) {
                this.deadline = System.currentTimeMillis() + _timeDelay;
            }
        }
    }

    public void add(Selection sel) {
        String string = LOCK;
        synchronized (string) {
            sel.stuffBounds(this._rects[this._nRects]);
            if (!this.merge(this._rects[this._nRects])) {
                ++this._nRects;
            }
            if (this._nRects == 10) {
                this.forceMerge();
            }
            if (this.deadline == (long)0) {
                this.deadline = System.currentTimeMillis() + _timeDelay;
            }
        }
    }

    private boolean merge(Rectangle r) {
        for (int i = 0; i < this._nRects; ++i) {
            if (!r.intersects(this._rects[i])) continue;
            this._rects[i].add(r);
            return true;
        }
        return false;
    }

    public void forceMerge() {
        for (int i = 1; i < this._nRects; ++i) {
            this._rects[0].add(this._rects[i]);
        }
        this._nRects = 1;
        this.deadline = 1L;
    }

    public static void lock() {
        String string = LOCK;
        synchronized (string) {
            ++_lockLevel;
        }
    }

    public static void unlock() {
        String string = LOCK;
        synchronized (string) {
            if (--_lockLevel < 0) {
                _lockLevel = 0;
            }
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(_timeDelay * (long)10);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repairDamage();
        }
    }

    public void repairDamage() {
        Graphics g = this._ed.getGraphics();
        if (_lockLevel == 0 && g != null) {
            String string = LOCK;
            synchronized (string) {
                if (_lockLevel == 0) {
                    this.paint(this._ed, g);
                }
            }
        }
    }

    private void paint(Editor ed, Graphics g) {
        if (Globals.getPrefs().shouldPaintOffScreen()) {
            this.paintOffscreen(ed, g);
        } else {
            this.paintOnscreen(ed, g);
        }
    }

    private void paintOnscreen(Editor ed, Graphics g) {
        int F = 16;
        if (ed == null || g == null) {
            return;
        }
        for (int i = 0; i < this._nRects; ++i) {
            Rectangle r = this._rects[i];
            Graphics offG = g.create();
            offG.setColor(ed.getBackground());
            offG.clearRect(r.x - F, r.y - F, r.width + F * 2, r.height + F * 2);
            offG.clipRect(r.x - F - 1, r.y - F - 1, r.width + F * 2 + 2, r.height + F * 2 + 2);
            ed.paint(offG);
            offG.dispose();
        }
        this.removeAllElements();
    }

    private void paintOffscreen(Editor ed, Graphics g) {
        int F = 16;
        if (ed == null || g == null) {
            return;
        }
        for (int i = 0; i < this._nRects; ++i) {
            Rectangle r = this._rects[i];
            r.setBounds(r.x - F, r.y - F, r.width + F * 2, r.height + F * 2);
            Image offscreen = this.findReusedImage(r.width, r.height, ed);
            r.width = offscreen.getWidth(null);
            r.height = offscreen.getHeight(null);
            if (offscreen == null) {
                System.out.println("failed to alloc image!!!");
                this.paintOnscreen(ed, g);
                return;
            }
            Graphics offG = offscreen.getGraphics();
            offG.translate(-r.x, -r.y);
            offG.setColor(ed.getBackground());
            offG.fillRect(r.x, r.y, r.width, r.height);
            offG.clipRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
            ed.paint(offG);
            g.drawImage(offscreen, r.x, r.y, null);
            offG.dispose();
            offscreen.flush();
        }
        this.removeAllElements();
    }

    protected Image findReusedImage(int x, int y, Editor ed) {
        if (x < 64 && y < 64) {
            if (this.image64x64 == null) {
                this.image64x64 = ed.createImage(64, 64);
            }
            return this.image64x64;
        }
        if (x < 256 && y < 64) {
            if (this.image256x64 == null) {
                this.image256x64 = ed.createImage(256, 64);
            }
            return this.image256x64;
        }
        if (x < 64 && y < 256) {
            if (this.image64x256 == null) {
                this.image64x256 = ed.createImage(64, 256);
            }
            return this.image64x256;
        }
        if (x < 256 && y < 256) {
            if (this.image256x256 == null) {
                this.image256x256 = ed.createImage(256, 256);
            }
            return this.image256x256;
        }
        if (x < 64 && y < 512) {
            if (this.image64x512 == null) {
                this.image64x512 = ed.createImage(64, 512);
            }
            return this.image64x512;
        }
        if (x < 512 && y < 64) {
            if (this.image512x64 == null) {
                this.image512x64 = ed.createImage(512, 64);
            }
            return this.image512x64;
        }
        if (x < 512 && y < 512) {
            if (this.image512x512 == null) {
                this.image512x512 = ed.createImage(512, 512);
            }
            return this.image512x512;
        }
        return ed.createImage(x, y);
    }
}

