/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.io.Serializable;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.FigEdge;
import uci.gef.FigNode;
import uci.gef.Layer;
import uci.gef.NetNode;
import uci.gef.NetPort;
import uci.gef.NetPrimitive;
import uci.graph.GraphEdgeHooks;
import uci.graph.GraphModel;

public abstract class NetEdge
extends NetPrimitive
implements GraphEdgeHooks,
Serializable {
    protected NetPort _sourcePort;
    protected NetPort _destPort;
    protected Vector _ports;

    public void setSourcePort(NetPort s) {
        this._sourcePort = s;
    }

    public NetPort getSourcePort() {
        return this._sourcePort;
    }

    public void setDestPort(NetPort d) {
        this._destPort = d;
    }

    public NetPort getDestPort() {
        return this._destPort;
    }

    public NetPort otherEnd(NetPort oneEnd) {
        NetPort sp = this.getSourcePort();
        if (sp == oneEnd) {
            return this.getDestPort();
        }
        return sp;
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector v) {
        this._ports = v;
    }

    public boolean connect(GraphModel gm, Object srcPort, Object destPort) {
        NetPort srcNetPort = (NetPort)srcPort;
        NetPort destNetPort = (NetPort)destPort;
        if (!srcNetPort.canConnectTo(gm, destPort)) {
            return false;
        }
        if (!destNetPort.canConnectTo(gm, srcPort)) {
            return false;
        }
        this.setSourcePort(srcNetPort);
        this.setDestPort(destNetPort);
        srcNetPort.addEdge(this);
        destNetPort.addEdge(this);
        srcNetPort.postConnect(gm, destPort);
        destNetPort.postConnect(gm, srcPort);
        return true;
    }

    public void dispose() {
        if (this.getSourcePort() != null && this.getDestPort() != null) {
            this._sourcePort.removeEdge(this);
            this._destPort.removeEdge(this);
            this._sourcePort.postDisconnect(null, this.getDestPort());
            this._destPort.postDisconnect(null, this.getSourcePort());
            this.firePropertyChange("Disposed", false, true);
        }
    }

    public FigEdge presentationFor(Layer lay) {
        FigEdge fe;
        if (lay != null && (fe = (FigEdge)lay.presentationFor(this)) != null) {
            return fe;
        }
        NetNode sourceNode = this._sourcePort.getParentNode();
        NetNode destNode = this._destPort.getParentNode();
        FigNode sourceFigNode = sourceNode.presentationFor(lay);
        FigNode destFigNode = destNode.presentationFor(lay);
        Fig sourcePortFig = sourceFigNode.getPortFig(this._sourcePort);
        Fig destPortFig = destFigNode.getPortFig(this._destPort);
        fe = this.makePresentation(lay);
        fe.sourcePortFig(sourcePortFig);
        fe.destPortFig(destPortFig);
        fe.sourceFigNode(sourceFigNode);
        fe.destFigNode(destFigNode);
        fe.setOwner(this);
        return fe;
    }

    public abstract FigEdge makePresentation(Layer var1);
}

