/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.Handle;
import uci.gef.Mode;
import uci.gef.SelectionManager;

public class ModeModify
extends Mode {
    public static final int MIN_DELTA = 4;
    public static final int NO_CONSTRAINT = 0;
    public static final int HORIZONTAL_CONSTRAINT = 1;
    public static final int VERTICAL_CONSTRAINT = 2;
    protected Point _anchor;
    protected int _lastX = 1000;
    protected int _lastY = 1000;
    protected int _startX;
    protected int _startY;
    protected boolean _minDeltaAchieved;
    protected Handle _curHandle = new Handle(-1);
    protected int _constraint = 0;
    private static Point snapPt;

    public ModeModify(Editor par) {
        super(par);
        this._anchor = new Point(0, 0);
    }

    public String instructions() {
        return "Modify selected objects";
    }

    public void mouseDragged(MouseEvent me) {
        int snapY;
        int snapX;
        int y;
        if (me.getModifiers() == 4) {
            return;
        }
        int x = me.getX();
        if (!this.checkMinDelta(x, y = me.getY())) {
            me.consume();
            return;
        }
        SelectionManager sm = this.getEditor().getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            me.consume();
            return;
        }
        Point point = snapPt;
        synchronized (point) {
            snapPt.setLocation(x, y);
            this.getEditor().snap(snapPt);
            snapX = ModeModify.snapPt.x;
            snapY = ModeModify.snapPt.y;
        }
        int dx = snapX - this._lastX;
        int dy = snapY - this._lastY;
        if (me.isControlDown() && this._constraint == 0) {
            if (dx != 0) {
                this._constraint = 1;
                Globals.showStatus("Moving objects horizontally");
            }
            if (dy != 0) {
                this._constraint = 2;
                Globals.showStatus("Moving objects vertically");
            }
        }
        if (this._constraint == 1) {
            dy = 0;
        }
        if (this._constraint == 2) {
            dx = 0;
        }
        if (dx == 0 && dy == 0) {
            me.consume();
            return;
        }
        sm.startTrans();
        if (this._curHandle.index == -1) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            sm.translate(dx, dy);
        } else if (this._curHandle.index >= 0) {
            this.setCursor(Cursor.getPredefinedCursor(1));
            sm.dragHandle(snapX, snapY, this._anchor.x, this._anchor.y, this._curHandle);
        }
        sm.endTrans();
        this._lastX = snapX;
        this._lastY = snapY;
        me.consume();
    }

    public void mousePressed(MouseEvent me) {
        if (me.getModifiers() == 4) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        this.start();
        SelectionManager sm = this.getEditor().getSelectionManager();
        if (sm.size() == 0) {
            this.done();
        }
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            me.consume();
            return;
        }
        this._anchor.x = sm.getBounds().x - x;
        this._anchor.y = sm.getBounds().y - y;
        this._curHandle.index = sm.hitHandle(new Rectangle(x - 4, y - 4, 8, 8));
        sm.endTrans();
        Point point = snapPt;
        synchronized (point) {
            snapPt.setLocation(x, y);
            this.getEditor().snap(snapPt);
            this._startX = this._lastX = ModeModify.snapPt.x;
            this._startY = this._lastY = ModeModify.snapPt.y;
        }
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (me.getModifiers() == 4) {
            return;
        }
        this.done();
        me.consume();
    }

    public void start() {
        this._minDeltaAchieved = false;
        super.start();
    }

    protected boolean checkMinDelta(int x, int y) {
        if (x > this._startX + 4 || x < this._startX - 4 || y > this._startY + 4 || y < this._startY - 4) {
            this._minDeltaAchieved = true;
        }
        return this._minDeltaAchieved;
    }

    static {
        MIN_DELTA = 4;
        NO_CONSTRAINT = 0;
        HORIZONTAL_CONSTRAINT = 1;
        VERTICAL_CONSTRAINT = 2;
        snapPt = new Point(0, 0);
    }
}

