/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Hashtable;
import uci.gef.Editor;
import uci.gef.Globals;

public abstract class Mode
implements Serializable,
KeyListener,
MouseListener,
MouseMotionListener {
    public Editor _editor;
    protected Hashtable _args;

    public Mode(Editor par) {
        this.setEditor(par);
    }

    public Mode() {
    }

    public void setEditor(Editor w) {
        this._editor = w;
        this.setCursor(this.getInitialCursor());
    }

    public Editor getEditor() {
        return this._editor;
    }

    public Cursor getInitialCursor() {
        return Cursor.getDefaultCursor();
    }

    public void setArgs(Hashtable args) {
        this._args = args;
    }

    public Hashtable getArgs() {
        return this._args;
    }

    public Object getArg(String s) {
        if (this._args == null) {
            return null;
        }
        return this._args.get(s);
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void done() {
        this.setCursor(Cursor.getDefaultCursor());
        this._editor.finishMode();
    }

    public void start() {
        Globals.nextMode();
    }

    public boolean canExit() {
        return true;
    }

    public String instructions() {
        return "Mode: ".concat(String.valueOf(String.valueOf(this.getClass().getName())));
    }

    public void setCursor(Cursor c) {
        if (this._editor != null) {
            this._editor.setCursor(c);
        }
    }

    public void paint(Graphics g) {
    }

    public void print(Graphics g) {
        this.paint(g);
    }
}

