/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.Layer;

public class LayerPageBreaks
extends Layer {
    private boolean _paintLines = true;
    protected Color _color = Color.darkGray;
    protected Dimension _pageSize = new Dimension(612, 792);

    public LayerPageBreaks() {
        super("PageBreaks");
    }

    public void setPageSize(Dimension d) {
        this._pageSize = d;
    }

    public Vector getContents() {
        return null;
    }

    public Fig presentationFor(Object obj) {
        return null;
    }

    public synchronized void paintContents(Graphics g) {
        if (g instanceof PrintGraphics) {
            return;
        }
        if (!this._paintLines) {
            return;
        }
        if (this._pageSize == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        int x = clip.x / this._pageSize.width * this._pageSize.width - this._pageSize.width;
        int y = clip.y / this._pageSize.height * this._pageSize.height - this._pageSize.height;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        int stepsY = (bot - y) / this._pageSize.height + 1;
        g.setColor(this._color);
        for (int stepsX = (right - x) / this._pageSize.width + 1; stepsX > 0; --stepsX) {
            g.drawLine(x - 1, 0, x - 1, bot);
            x += this._pageSize.width;
        }
        while (stepsY > 0) {
            g.drawLine(0, y - 1, right, y - 1);
            y += this._pageSize.height;
            --stepsY;
        }
    }

    public void adjust() {
        this._paintLines = !this._paintLines;
        this.refreshEditors();
    }
}

