/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Layer;

public class LayerGrid
extends Layer {
    private int _spacing = 16;
    private boolean _paintLines = false;
    private transient Image _stamp = null;
    private int _stampWidth = 128;
    private int _stampHeight = 128;
    protected Color _color = Color.gray;
    protected Color _bgColor = Color.lightGray;
    protected boolean _paintBackground = true;
    protected int _dotSize = 2;
    private int _style = 2;
    private final int NUM_STYLES = 5;

    public LayerGrid() {
        super("Grid");
    }

    public LayerGrid(Color fore, Color back, int spacing, boolean lines) {
        super("Grid");
        this._color = fore;
        this._bgColor = back;
        this._spacing = spacing;
        this._paintLines = lines;
    }

    public Vector getContents() {
        return null;
    }

    public Fig presentationFor(Object obj) {
        return null;
    }

    public synchronized void paintContents(Graphics g) {
        if (g instanceof PrintGraphics) {
            if (!Globals.getPrefs().getPrintGrid()) {
                return;
            }
            if (this._paintLines) {
                this.paintLines(g, Globals.getPrefs().getPrintBackground());
            } else {
                this.paintDots(g, Globals.getPrefs().getPrintBackground());
            }
            return;
        }
        if (this._stamp == null) {
            if (this._spacing > this._stampHeight) {
                this._stampHeight = this._stampWidth = this._spacing;
            }
            if (Globals.curEditor() == null) {
                System.out.println("no editor");
                Frame frame = new Frame();
                frame.show();
                this._stamp = frame.createImage(this._stampWidth, this._stampHeight);
                frame.dispose();
            } else {
                this._stamp = Globals.curEditor().createImage(this._stampWidth, this._stampHeight);
            }
            if (this._stamp != null) {
                if (this._paintLines) {
                    this.paintLines(this._stamp, this._paintBackground);
                } else {
                    this.paintDots(this._stamp, this._paintBackground);
                }
            }
        }
        Rectangle clip = g.getClipBounds();
        int y = clip.y / this._spacing * this._spacing;
        int bot = clip.y + clip.height;
        int right = clip.x + clip.width;
        if (this._stamp != null) {
            for (int x = clip.x / this._spacing * this._spacing; x <= right; x += this._stampWidth) {
                for (y = clip.y / this._spacing * this._spacing; y <= bot; y += this._stampHeight) {
                    g.drawImage(this._stamp, x, y, null);
                }
            }
        }
    }

    private void paintLines(Image i, boolean paintBackground) {
        Graphics g = i.getGraphics();
        g.clipRect(0, 0, i.getWidth(null), i.getHeight(null));
        this.paintLines(g, paintBackground);
    }

    private void paintDots(Image i, boolean paintBackground) {
        Graphics g = i.getGraphics();
        g.clipRect(0, 0, i.getWidth(null), i.getHeight(null));
        this.paintDots(g, paintBackground);
    }

    private void paintLines(Graphics g, boolean paintBackground) {
        Rectangle clip = g.getClipBounds();
        if (paintBackground) {
            g.setColor(Color.white);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int x = clip.x / this._spacing * this._spacing - this._spacing;
        int y = clip.y / this._spacing * this._spacing - this._spacing;
        int stepsY = clip.height / this._spacing + 2;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        g.setColor(this._color);
        for (int stepsX = clip.width / this._spacing + 2; stepsX > 0; --stepsX) {
            g.drawLine(x, 0, x, bot);
            x += this._spacing;
        }
        while (stepsY > 0) {
            g.drawLine(0, y, right, y);
            y += this._spacing;
            --stepsY;
        }
    }

    protected void paintDots(Graphics g, boolean paintBackground) {
        Rectangle clip = g.getClipBounds();
        if (paintBackground) {
            g.setColor(this._bgColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int y = clip.y / this._spacing * this._spacing - this._spacing;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        g.setColor(this._color);
        for (int x = clip.x / this._spacing * this._spacing - this._spacing; x <= right; x += this._spacing) {
            for (y = 0; y <= bot; y += this._spacing) {
                g.fillRect(x, y, this._dotSize, this._dotSize);
            }
        }
    }

    public void adjust() {
        this._style = (this._style + 1) % 5;
        this._stamp = null;
        switch (this._style) {
            case 0: {
                this.setHidden(false);
                this._paintLines = true;
                this._spacing = 16;
                break;
            }
            case 1: {
                this.setHidden(false);
                this._paintLines = true;
                this._spacing = 8;
                break;
            }
            case 2: {
                this.setHidden(false);
                this._paintLines = false;
                this._spacing = 16;
                break;
            }
            case 3: {
                this.setHidden(false);
                this._paintLines = false;
                this._spacing = 32;
                break;
            }
            case 4: {
                this.setHidden(true);
            }
        }
        this.refreshEditors();
    }
}

