/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Arco;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.FigNode;
import uci.gef.Layer;
import uci.gef.Nodo;
import uci.util.Dbg;

public class LayerDiagram
extends Layer {
    protected Vector _contents = new Vector();
    protected static int _nextLayerNumbered = 1;

    public LayerDiagram() {
        this("Layer".concat(String.valueOf(String.valueOf(LayerDiagram.numberWordFor(_nextLayerNumbered++)))));
    }

    public LayerDiagram(String name) {
        super(name);
        this._onMenu = true;
    }

    protected static String numberWordFor(int n) {
        switch (n) {
            case 1: {
                return "One";
            }
            case 2: {
                return "Two";
            }
            case 3: {
                return "Three";
            }
            case 4: {
                return "Four";
            }
            case 5: {
                return "Five";
            }
            case 6: {
                return "Six";
            }
            case 7: {
                return "Seven";
            }
            case 8: {
                return "Eight";
            }
            case 9: {
                return "Nine";
            }
        }
        return "Layer ".concat(String.valueOf(String.valueOf(n)));
    }

    public void add(Fig f) {
        Dbg.assert(f != null, "tried to add null Fig");
        this._contents.removeElement(f);
        this._contents.addElement(f);
        f.setLayer(this);
        f.endTrans();
    }

    public void insertAt(Fig f, int index) {
        Dbg.assert(f != null, "tried to insert null Fig");
        this._contents.removeElement(f);
        this._contents.insertElementAt(f, index);
        f.setLayer(this);
        f.endTrans();
    }

    public int indexOf(Fig f) {
        Dbg.assert(f != null, "tried to find null Fig");
        return this._contents.indexOf(f);
    }

    public void remove(Fig f) {
        this._contents.removeElement(f);
        f.endTrans();
        f.setLayer(null);
    }

    public Enumeration elements() {
        return this._contents.elements();
    }

    public Vector getContents() {
        return this._contents;
    }

    public Fig hit(Rectangle r) {
        for (int i = this._contents.size() - 1; i >= 0; --i) {
            Fig f = (Fig)this._contents.elementAt(i);
            if (!f.hit(r)) continue;
            return f;
        }
        return null;
    }

    public void removeAll() {
        for (int i = this._contents.size() - 1; i >= 0; --i) {
            Fig f = (Fig)this._contents.elementAt(i);
            f.setLayer(null);
        }
        this._contents.removeAllElements();
    }

    public void damaged(Fig f) {
        Enumeration eds = this._editors.elements();
        while (eds.hasMoreElements()) {
            Editor edd = (Editor)eds.nextElement();
            edd.damaged(f);
            Vector arcos = this.getContents();
            if (f.getClass().getName().compareTo("uci.gef.Nodo") != 0) continue;
            for (int j = 0; j < arcos.size(); ++j) {
                if (arcos.elementAt(j).getClass().getName().compareTo("uci.gef.Arco") != 0) continue;
                if (((Arco)arcos.elementAt(j)).origen().compareTo(((Nodo)f).identificador()) == 0) {
                    edd.damaged((Arco)arcos.elementAt(j));
                    continue;
                }
                if (((Arco)arcos.elementAt(j)).destino().compareTo(((Nodo)f).identificador()) != 0) continue;
                edd.damaged((Arco)arcos.elementAt(j));
            }
        }
    }

    public FigNode getPortFig(Object port) {
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            FigNode fn;
            Fig port_fig;
            Fig f = (Fig)figs.nextElement();
            if (!(f instanceof FigNode) || (port_fig = (fn = (FigNode)f).getPortFig(port)) == null) continue;
            return fn;
        }
        return null;
    }

    public Fig presentationFor(Object obj) {
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (f.getOwner() != obj) continue;
            return f;
        }
        return null;
    }

    public void paintContents(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (clip != null && !f.getBounds().intersects(clip)) continue;
            f.paint(g);
        }
    }

    public void sendToBack(Fig f) {
        this._contents.removeElement(f);
        this._contents.insertElementAt(f, 0);
    }

    public void bringToFront(Fig f) {
        this._contents.removeElement(f);
        this._contents.addElement(f);
    }

    public void sendBackward(Fig f) {
        int i = this._contents.indexOf(f);
        if (i == -1 || i == 0) {
            return;
        }
        Object prevFig = this._contents.elementAt(i - 1);
        this._contents.setElementAt(prevFig, i);
        this._contents.setElementAt(f, i - 1);
    }

    public void bringForward(Fig f) {
        int i = this._contents.indexOf(f);
        if (i == -1 || i == this._contents.size() - 1) {
            return;
        }
        Object nextFig = this._contents.elementAt(i + 1);
        this._contents.setElementAt(nextFig, i);
        this._contents.setElementAt(f, i + 1);
    }

    public void reorder(Fig f, int function) {
        switch (function) {
            case 1: {
                this.sendToBack(f);
                break;
            }
            case 2: {
                this.bringToFront(f);
                break;
            }
            case 3: {
                this.sendBackward(f);
                break;
            }
            case 4: {
                this.bringForward(f);
            }
        }
    }
}

