/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.PredFigInRect;
import uci.util.EnumerationEmpty;
import uci.util.EnumerationPredicate;

public abstract class Layer
implements Serializable {
    private String _name = "aLayer";
    private String _type = "aLayer";
    private boolean _hidden = false;
    private boolean _grayed = false;
    private boolean _locked = false;
    protected boolean _onMenu = false;
    public Vector _editors = new Vector();

    public Layer() {
    }

    public Layer(String name) {
        this._name = name;
    }

    public Layer(String name, String type) {
        this._name = name;
        this._type = type;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.toString()))).append("[").append(this._name).append("]")));
    }

    public Layer findLayerNamed(String aName) {
        return aName.equals(this._name) ? this : null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String n) {
        this._name = n;
    }

    public void setHidden(boolean b) {
        this._hidden = b;
    }

    public boolean fetHidden() {
        return this._hidden;
    }

    public void setGrayed(boolean b) {
        this._grayed = b;
    }

    public boolean getGrayed() {
        return this._grayed;
    }

    public void setLocked(boolean b) {
        this._locked = b;
    }

    public boolean getLocked() {
        return this._locked;
    }

    public void setOnMenu(boolean b) {
        this._onMenu = b;
    }

    public boolean getOnMenu() {
        return this._onMenu;
    }

    public abstract Vector getContents();

    public Vector getEditors() {
        return this._editors;
    }

    public void add(Fig f) {
    }

    public void remove(Fig f) {
    }

    public void removeAll() {
    }

    public Enumeration elements() {
        return EnumerationEmpty.theInstance();
    }

    public Fig hit(Rectangle r) {
        return null;
    }

    public Enumeration elementsIn(Rectangle r) {
        return new EnumerationPredicate(this.elements(), new PredFigInRect(r));
    }

    public abstract Fig presentationFor(Object var1);

    public String getPerspectiveType() {
        return this._type;
    }

    public void setPerspectiveType(String t) {
        this._type = t;
    }

    public void sendToBack(Fig f) {
    }

    public void bringForward(Fig f) {
    }

    public void sendBackward(Fig f) {
    }

    public void bringToFront(Fig f) {
    }

    public void reorder(Fig f, int function) {
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this._hidden) {
            return;
        }
        if (!this._grayed) {
            this.paintContents(g);
        } else {
            this.paintGrayContents(g);
        }
    }

    public abstract void paintContents(Graphics var1);

    public void paintGrayContents(Graphics g) {
        g.setColor(Color.white);
        this.paintContents(g);
    }

    public void damaged(Fig f) {
        Enumeration eds = this._editors.elements();
        while (eds.hasMoreElements()) {
            ((Editor)eds.nextElement()).damaged(f);
        }
    }

    public void deleted(Fig f) {
        Enumeration eds = this._editors.elements();
        while (eds.hasMoreElements()) {
            ((Editor)eds.nextElement()).removed(f);
        }
    }

    public void refreshEditors() {
        Enumeration eds = this._editors.elements();
        while (eds.hasMoreElements()) {
            ((Editor)eds.nextElement()).damageAll();
        }
    }

    public void addEditor(Editor ed) {
        this._editors.addElement(ed);
    }

    public void removeEditor(Editor ed) {
        this._editors.removeElement(ed);
    }

    public void adjust() {
    }
}

