/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import servicios.DatoSistema;
import servicios.GestorLiterales;
import uci.gef.CmdAdjustGrid;
import uci.gef.CmdAdjustGuide;
import uci.gef.CmdAdjustPageBreaks;
import uci.gef.CmdAlign;
import uci.gef.CmdDelete;
import uci.gef.CmdExit;
import uci.gef.CmdGroup;
import uci.gef.CmdNudge;
import uci.gef.CmdOpen;
import uci.gef.CmdOpenWindow;
import uci.gef.CmdPrint;
import uci.gef.CmdReorder;
import uci.gef.CmdSave;
import uci.gef.CmdSelectAll;
import uci.gef.CmdSelectInvert;
import uci.gef.CmdSelectNext;
import uci.gef.CmdShowProperties;
import uci.gef.CmdSpawn;
import uci.gef.CmdUngroup;
import uci.gef.CmdUseReshape;
import uci.gef.CmdUseResize;
import uci.gef.CmdUseRotate;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.JGraph;
import uci.gef.JGraphFrame_this_focusAdapter;
import uci.gef.PaletteFig;
import uci.graph.GraphEdgeRenderer;
import uci.graph.GraphModel;
import uci.graph.GraphNodeRenderer;
import uci.ui.IStatusBar;
import uci.ui.ToolBar;

public class JGraphFrame
extends JFrame
implements IStatusBar,
Cloneable {
    protected ToolBar _toolbar = new PaletteFig();
    protected JGraph _graph;
    protected JLabel _statusbar = new JLabel(" ");
    protected JPanel _mainPanel = new JPanel(new BorderLayout());
    protected JPanel _graphPanel = new JPanel(new BorderLayout());
    protected JMenuBar _menubar = new JMenuBar();
    protected JPanel _panelCerrar = new JPanel(new FlowLayout());
    protected JButton _botonCerrar = new JButton();

    public JGraphFrame() {
        this("Aut\u00f3mata SLR(1)");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JGraphFrame(GraphModel gm) {
        this("Aut\u00f3mata SLR(1)");
        this.setGraphModel(gm);
    }

    public JGraphFrame(String title) {
        this(title, new JGraph());
    }

    public JGraphFrame(String title, Editor ed) {
        this(title, new JGraph(ed));
    }

    public JGraphFrame(String title, JGraph jg) {
        super(title);
        this._graph = jg;
        Container content = this.getContentPane();
        GestorLiterales gesLit = (GestorLiterales)DatoSistema.darDato("GESTOR_LITERALES");
        this._botonCerrar.setLabel(String.valueOf(String.valueOf(new StringBuffer("     ").append(gesLit.darLiteral("submenuCerrar")).append("     "))));
        this._botonCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JGraphFrame.this._botonCerrar_actionPerformed(e);
            }
        });
        content.setLayout(new BorderLayout());
        this._panelCerrar.add(this._botonCerrar);
        this._graphPanel.add((Component)this._graph, "Center");
        this._graphPanel.setBorder(new EtchedBorder(1));
        this._mainPanel.add((Component)this._graphPanel, "Center");
        content.add((Component)this._mainPanel, "Center");
        content.add((Component)this._panelCerrar, "South");
        ((Component)this).setSize(300, 250);
    }

    void _botonCerrar_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    protected void setUpMenus() {
        JMenu file = new JMenu("File");
        file.setMnemonic('F');
        this._menubar.add(file);
        JMenuItem openItem = file.add(new CmdOpen());
        JMenuItem saveItem = file.add(new CmdSave());
        JMenuItem printItem = file.add(new CmdPrint());
        JMenuItem prefsItem = file.add(new CmdOpenWindow("uci.gef.PrefsEditor", "Preferences..."));
        JMenuItem exitItem = file.add(new CmdExit());
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic('E');
        this._menubar.add(edit);
        JMenu select = new JMenu("Select");
        edit.add(select);
        JMenuItem selectAllItem = select.add(new CmdSelectAll());
        select.add(new CmdSelectNext(false));
        select.add(new CmdSelectNext(true));
        select.add(new CmdSelectInvert());
        JMenuItem deleteItem = edit.add(new CmdDelete());
        edit.addSeparator();
        edit.add(new CmdUseReshape());
        edit.add(new CmdUseResize());
        edit.add(new CmdUseRotate());
        edit.addSeparator();
        JMenu view = new JMenu("View");
        this._menubar.add(view);
        view.setMnemonic('V');
        view.add(new CmdSpawn());
        view.add(new CmdShowProperties());
        view.addSeparator();
        view.add(new CmdAdjustGrid());
        view.add(new CmdAdjustGuide());
        view.add(new CmdAdjustPageBreaks());
        JMenu arrange = new JMenu("Arrange");
        this._menubar.add(arrange);
        arrange.setMnemonic('A');
        JMenuItem groupItem = arrange.add(new CmdGroup());
        groupItem.setMnemonic('G');
        JMenuItem ungroupItem = arrange.add(new CmdUngroup());
        ungroupItem.setMnemonic('U');
        JMenu align = new JMenu("Align");
        arrange.add(align);
        align.add(new CmdAlign(0));
        align.add(new CmdAlign(1));
        align.add(new CmdAlign(2));
        align.add(new CmdAlign(3));
        align.add(new CmdAlign(5));
        align.add(new CmdAlign(6));
        align.add(new CmdAlign(7));
        JMenu reorder = new JMenu("Reorder");
        arrange.add(reorder);
        JMenuItem toBackItem = reorder.add(new CmdReorder(1));
        JMenuItem toFrontItem = reorder.add(new CmdReorder(2));
        JMenuItem backwardItem = reorder.add(new CmdReorder(3));
        JMenuItem forwardItem = reorder.add(new CmdReorder(4));
        JMenu nudge = new JMenu("Nudge");
        arrange.add(nudge);
        JMenuItem nudgeLeftItem = nudge.add(new CmdNudge(1));
        JMenuItem nudgeRightItem = nudge.add(new CmdNudge(2));
        JMenuItem nudgeUpItem = nudge.add(new CmdNudge(3));
        JMenuItem nudgeDownItem = nudge.add(new CmdNudge(4));
        KeyStroke ctrlN = KeyStroke.getKeyStroke(78, 2);
        KeyStroke ctrlO = KeyStroke.getKeyStroke(79, 2);
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, 2);
        KeyStroke ctrlP = KeyStroke.getKeyStroke(80, 2);
        KeyStroke altF4 = KeyStroke.getKeyStroke(115, 8);
        KeyStroke leftArrow = KeyStroke.getKeyStroke(37, 0);
        KeyStroke rightArrow = KeyStroke.getKeyStroke(39, 0);
        KeyStroke upArrow = KeyStroke.getKeyStroke(38, 0);
        KeyStroke downArrow = KeyStroke.getKeyStroke(40, 0);
        KeyStroke sLeftArrow = KeyStroke.getKeyStroke(37, 1);
        KeyStroke sRightArrow = KeyStroke.getKeyStroke(39, 1);
        KeyStroke sUpArrow = KeyStroke.getKeyStroke(38, 1);
        KeyStroke sDownArrow = KeyStroke.getKeyStroke(40, 1);
        KeyStroke delKey = KeyStroke.getKeyStroke(127, 0);
        KeyStroke ctrlG = KeyStroke.getKeyStroke(71, 2);
        KeyStroke ctrlU = KeyStroke.getKeyStroke(85, 2);
        KeyStroke ctrlB = KeyStroke.getKeyStroke(66, 2);
        KeyStroke ctrlF = KeyStroke.getKeyStroke(70, 2);
        KeyStroke sCtrlB = KeyStroke.getKeyStroke(66, 3);
        KeyStroke sCtrlF = KeyStroke.getKeyStroke(70, 3);
        openItem.setAccelerator(ctrlO);
        saveItem.setAccelerator(ctrlS);
        printItem.setAccelerator(ctrlP);
        exitItem.setAccelerator(altF4);
        deleteItem.setAccelerator(delKey);
        groupItem.setAccelerator(ctrlG);
        ungroupItem.setAccelerator(ctrlU);
        toBackItem.setAccelerator(sCtrlB);
        toFrontItem.setAccelerator(sCtrlF);
        backwardItem.setAccelerator(ctrlB);
        forwardItem.setAccelerator(ctrlF);
    }

    public JGraph getGraph() {
        return this._graph;
    }

    public void setGraph(JGraph g) {
        this._graph = g;
    }

    public void setGraphModel(GraphModel gm) {
        this._graph.setGraphModel(gm);
    }

    public GraphModel getGraphModel() {
        return this._graph.getGraphModel();
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        this._graph.getEditor().setGraphNodeRenderer(rend);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._graph.getEditor().getGraphNodeRenderer();
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        this._graph.getEditor().setGraphEdgeRenderer(rend);
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._graph.getEditor().getGraphEdgeRenderer();
    }

    public void setToolBar(ToolBar tb) {
        this._toolbar = tb;
        this._mainPanel.add((Component)this._toolbar, "North");
    }

    public ToolBar getToolBar() {
        return this._toolbar;
    }

    public void setJMenuBar(JMenuBar mb) {
        this._menubar = mb;
        this.getContentPane().add((Component)this._menubar, "North");
    }

    public JMenuBar getJMenuBar() {
        return this._menubar;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            Globals.setStatusBar(this);
        }
    }

    public Object clone() {
        return null;
    }

    public void showStatus(String msg) {
        if (this._statusbar != null) {
            this._statusbar.setText(msg);
        }
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.addFocusListener(new JGraphFrame_this_focusAdapter(this));
    }

    void this_focusGained(FocusEvent e) {
        Graphics pantalla = ((Component)this).getGraphics();
        this.update(pantalla);
    }
}

