/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Mode;
import uci.gef.ModeSelect;
import uci.gef.Prefs;
import uci.ui.IStatusBar;
import uci.ui.TabPropFrame;

public class Globals {
    public static final String REMOVE = "Remove";
    public static final String HIGHLIGHT = "Highlight";
    public static final String UNHIGHLIGHT = "Unhighlight";
    protected static AppletContext _appletContext;
    protected static Applet _applet;
    protected static MediaTracker _tracker;
    protected static TabPropFrame _tabPropFrame;
    public static String defaultStatus;
    public static IStatusBar _StatusBar;
    protected static Prefs _prefs;
    protected static boolean _sticky;
    protected static Mode _mode;
    protected static Editor _curEditor;
    protected static Hashtable _pcListeners;
    public static int MAX_LISTENERS;

    public static void setApplet(Applet a) {
        _applet = a;
        _appletContext = a.getAppletContext();
        Globals.clearStatus();
        _tracker = new MediaTracker(a);
    }

    public static AppletContext getAppletContext() {
        return _appletContext;
    }

    public static Applet getApplet() {
        return _applet;
    }

    public static void setStatusBar(IStatusBar sb) {
        _StatusBar = sb;
    }

    public static void showStatus(String s) {
        if (_StatusBar != null) {
            _StatusBar.showStatus(s);
        } else if (_appletContext != null) {
            _appletContext.showStatus(s);
        }
    }

    public static void clearStatus() {
        Globals.showStatus(defaultStatus);
    }

    public static void showDocument(URL url) {
        if (_appletContext != null) {
            _appletContext.showDocument(url);
        }
    }

    public static void showDocument(URL url, String target) {
        if (_appletContext != null) {
            _appletContext.showDocument(url, target);
        }
    }

    public static void showDocument(String urlString) {
        try {
            Globals.showDocument(new URL(urlString));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static Image getImage(URL url) {
        Image img = null;
        if (_appletContext != null) {
            img = _appletContext.getImage(url);
        }
        if (_tracker != null && img != null) {
            _tracker.addImage(img, 1);
        }
        return img;
    }

    public static Image getImage(String urlStr) {
        try {
            Image img = null;
            if (_appletContext != null) {
                img = _appletContext.getImage(new URL(urlStr));
            }
            if (_tracker != null && img != null) {
                _tracker.addImage(img, 1);
            }
            Image image = img;
            return image;
        }
        catch (MalformedURLException e) {
            Image image = null;
            return image;
        }
    }

    public static void waitForImages() {
        if (_tracker == null) {
            return;
        }
        try {
            _tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void quit() {
        Globals.showStatus("Quiting");
        if (_appletContext != null) {
            _applet.destroy();
        }
        System.exit(0);
    }

    public static Prefs getPrefs() {
        return _prefs;
    }

    public static void setPropertySheet(TabPropFrame tpf) {
        _tabPropFrame = tpf;
    }

    public static void startPropertySheet() {
        if (_tabPropFrame == null) {
            _tabPropFrame = new TabPropFrame();
        }
        if (_tabPropFrame.isVisible()) {
            _tabPropFrame.toFront();
        } else {
            _tabPropFrame.show();
        }
        if (Globals.curEditor() == null) {
            return;
        }
        Vector selectedFigs = Globals.curEditor().getSelectionManager().getFigs();
        if (selectedFigs.size() == 1) {
            Globals.propertySheetSubject((Fig)selectedFigs.elementAt(0));
        }
    }

    public static void propertySheetSubject(Fig f) {
        if (_tabPropFrame != null) {
            _tabPropFrame.select(f);
        }
    }

    public static Frame someFrame() {
        return _tabPropFrame;
    }

    public static void setSticky(boolean b) {
        _sticky = b;
    }

    protected static Mode defaultMode() {
        return new ModeSelect();
    }

    public static void mode(Mode m) {
        _mode = m;
    }

    public static void mode(Mode m, boolean s) {
        _mode = m;
        _sticky = s;
    }

    public static Mode mode() {
        if (_mode == null) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static Mode nextMode() {
        if (!_sticky) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static void curEditor(Editor ce) {
        _curEditor = ce;
    }

    public static Editor curEditor() {
        return _curEditor;
    }

    public static void addPropertyChangeListener(Object src, PropertyChangeListener l) {
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(src);
        if (listeners == null) {
            listeners = new PropertyChangeListener[MAX_LISTENERS];
            _pcListeners.put(src, listeners);
        }
        for (int i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] != null) continue;
            listeners[i] = l;
            return;
        }
        System.out.println("ran out of listeners!");
    }

    public static void removePropertyChangeListener(Object s, PropertyChangeListener l) {
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(s);
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] != l) continue;
            listeners[i] = null;
            return;
        }
        System.out.println("listener not found!");
    }

    public static void firePropChange(Object src, String propName, boolean oldV, boolean newV) {
        Globals.firePropChange(src, propName, new Boolean(oldV), new Boolean(newV));
    }

    public static void firePropChange(Object src, String propName, int oldV, int newV) {
        Globals.firePropChange(src, propName, new Integer(oldV), new Integer(newV));
    }

    public static void firePropChange(Object src, String propName, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeListener[] listeners = (PropertyChangeListener[])_pcListeners.get(src);
        if (listeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(src, propName, oldValue, newValue);
        for (int i = 0; i < MAX_LISTENERS; ++i) {
            if (listeners[i] == null) continue;
            listeners[i].propertyChange(evt);
        }
    }

    static {
        REMOVE = REMOVE;
        HIGHLIGHT = HIGHLIGHT;
        UNHIGHLIGHT = UNHIGHLIGHT;
        defaultStatus = "  ";
        _StatusBar = null;
        _prefs = new Prefs();
        if (_tabPropFrame == null) {
            _tabPropFrame = new TabPropFrame();
        }
        _sticky = false;
        _pcListeners = new Hashtable();
        MAX_LISTENERS = 4;
    }
}

