/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import uci.gef.Fig;
import uci.ui.PropCategoryManager;

public class FigText
extends Fig
implements KeyListener {
    public final int JUSTIFY_LEFT = 0;
    public final int JUSTIFY_RIGHT = 1;
    public final int JUSTIFY_CENTER = 2;
    public final int MIN_TEXT_WIDTH = 30;
    protected Font _font = new Font("Times", 0, 10);
    protected transient FontMetrics _fm;
    protected int _lineHeight;
    protected Color _textColor = Color.black;
    protected Color _textFillColor = Color.white;
    protected boolean _textFilled = false;
    protected boolean _underline = false;
    protected int _lineSpacing = -4;
    protected int _topMargin = 1;
    protected int _botMargin = 1;
    protected int _leftMargin = 1;
    protected int _rightMargin = 1;
    protected boolean _expandOnly = false;
    protected int _justification;
    protected String _curText;

    public FigText(int x, int y, int w, int h, Color textColor, String familyName, int fontSize) {
        super(x, y, w, h);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this._textColor = textColor;
        this._font = new Font(familyName, 0, fontSize);
        this._justification = 2;
        this._curText = "";
    }

    public FigText(int x, int y, int w, int h) {
        this(x, y, w, h, Color.blue, "Times", 10);
    }

    public boolean OK() {
        if (!super.OK()) {
            return false;
        }
        return this._font != null && this._lineSpacing > -20 && this._topMargin >= 0 && this._botMargin >= 0 && this._leftMargin >= 0 && this._rightMargin >= 0 && (this._justification == 0 || this._justification == 2 || this._justification == 1) && this._textColor != null && this._textFillColor != null;
    }

    public String getJustificationByName() {
        if (this._justification == 0) {
            return "Left";
        }
        if (this._justification == 2) {
            return "Center";
        }
        if (this._justification == 1) {
            return "Right";
        }
        System.out.println("internal error, unknown text alignment");
        return "Unknown";
    }

    public void setJustifciaionByName(String justifyString) {
        if (justifyString.equals("Left")) {
            this._justification = 0;
        } else if (justifyString.equals("Center")) {
            this._justification = 2;
        } else if (justifyString.equals("Right")) {
            this._justification = 1;
        }
        this._fm = null;
    }

    public Color getTextColor() {
        return this._textColor;
    }

    public void setTextColor(Color c) {
        this.firePropChange("textColor", this._textColor, c);
        this._textColor = c;
    }

    public Color getTextFillColor() {
        return this._textFillColor;
    }

    public void setTextFillColor(Color c) {
        this.firePropChange("textFillColor", this._textFillColor, c);
        this._textFillColor = c;
    }

    public boolean getTextFilled() {
        return this._textFilled;
    }

    public void setTextFilled(boolean b) {
        this.firePropChange("textFilled", this._textFilled, b);
        this._textFilled = b;
    }

    public boolean getUnderline() {
        return this._underline;
    }

    public void setUnderline(boolean b) {
        this.firePropChange("underline", this._underline, b);
        this._underline = b;
    }

    public String getJustification() {
        return this.getJustificationByName();
    }

    public void setJustification(String align) {
        this.firePropChange("justifciaion", this.getJustificationByName(), align);
        this.setJustifciaionByName(align);
    }

    public int getLineSpacing() {
        return this._lineSpacing;
    }

    public void setLineSpacing(int s) {
        this.firePropChange("lineSpacing", this._lineSpacing, s);
        this._lineSpacing = s;
        this.calcBounds();
    }

    public int getTopMargin() {
        return this._topMargin;
    }

    public void setTopMargin(int m) {
        this.firePropChange("topMargin", this._topMargin, m);
        this._topMargin = m;
        this.calcBounds();
    }

    public int getBotMargin() {
        return this._botMargin;
    }

    public void setBotMargin(int m) {
        this.firePropChange("botMargin", this._botMargin, m);
        this._botMargin = m;
        this.calcBounds();
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(int m) {
        this.firePropChange("leftMargin", this._leftMargin, m);
        this._leftMargin = m;
        this.calcBounds();
    }

    public int getRightMargin() {
        return this._rightMargin;
    }

    public void setRightMargin(int m) {
        this.firePropChange("rightMargin", this._rightMargin, m);
        this._rightMargin = m;
        this.calcBounds();
    }

    public boolean getExpandOnly() {
        return this._expandOnly;
    }

    public void setExpandOnly(boolean b) {
        this.firePropChange("expandOnly", this._expandOnly, b);
        this._expandOnly = b;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font f) {
        this.firePropChange("font", this._font, f);
        this._font = f;
        this._fm = null;
        this.calcBounds();
    }

    public boolean getItalic() {
        return this._font.isItalic();
    }

    public void setItalic(boolean b) {
        int style = (this.getBold() ? 1 : 0) + (b ? 2 : 0);
        Font f = new Font(this._font.getFamily(), this._font.getSize(), style);
        this.setFont(f);
    }

    public boolean getBold() {
        return this._font.isBold();
    }

    public void setBold(boolean b) {
        int style = (b ? 1 : 0) + (this.getItalic() ? 2 : 0);
        this.setFont(new Font(this._font.getFamily(), this._font.getSize(), style));
    }

    public String deleteLastCharFromString(String s) {
        int len = Math.max(s.length() - 1, 0);
        char[] chars = s.toCharArray();
        return new String(chars, 0, len);
    }

    public void deleteLastChar() {
        this._curText = this.deleteLastCharFromString(this._curText);
        this.calcBounds();
    }

    public void append(char c) {
        this.setText(String.valueOf(String.valueOf(this._curText)).concat(String.valueOf(String.valueOf(c))));
    }

    public void append(String s) {
        this.setText(String.valueOf(String.valueOf(this._curText)).concat(String.valueOf(String.valueOf(s))));
    }

    public void setText(String s) {
        this._curText = s;
        this.calcBounds();
    }

    public String getText() {
        return this._curText;
    }

    public void paint(Graphics g) {
        int chunkW;
        String curLine;
        StringTokenizer lines;
        int chunkX = this._x + this._leftMargin;
        int chunkY = this._y + this._topMargin;
        if (this._filled) {
            g.setColor(this._fillColor);
            g.fillRect(this._x, this._y, this._w, this._h);
        }
        if (this._lineWidth > 0) {
            g.setColor(this._lineColor);
            g.drawRect(this._x - 1, this._y - 1, this._w + 1, this._h + 1);
        }
        if (this._font != null) {
            g.setFont(this._font);
        }
        this._fm = g.getFontMetrics(this._font);
        int chunkH = this._lineHeight + this._lineSpacing;
        chunkY = this._y + this._topMargin + chunkH;
        if (this._textFilled) {
            g.setColor(this._textFillColor);
            lines = new StringTokenizer(this._curText, "\n\r", true);
            while (lines.hasMoreTokens()) {
                curLine = lines.nextToken();
                chunkW = this._fm.stringWidth(curLine);
                switch (this._justification) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        chunkX = this._x + (this._w - chunkW) / 2;
                        break;
                    }
                    case 1: {
                        chunkX = this._x + this._w - chunkW - this._rightMargin;
                    }
                }
                if (curLine.equals("\n") || curLine.equals("\r")) {
                    chunkY += chunkH;
                    continue;
                }
                g.fillRect(chunkX, chunkY - chunkH, chunkW, chunkH);
            }
        }
        g.setColor(this._textColor);
        chunkX = this._x + this._leftMargin;
        chunkY = this._y + this._topMargin + this._lineHeight + this._lineSpacing;
        lines = new StringTokenizer(this._curText, "\n\r", true);
        while (lines.hasMoreTokens()) {
            curLine = lines.nextToken();
            chunkW = this._fm.stringWidth(curLine);
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    chunkX = this._x + (this._w - chunkW) / 2;
                    break;
                }
                case 1: {
                    chunkX = this._x + this._w - chunkW;
                }
            }
            if (curLine.equals("\n") || curLine.equals("\r")) {
                chunkY += chunkH;
                continue;
            }
            g.drawString(curLine, chunkX, chunkY);
        }
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getModifiers() != 0) {
            return;
        }
        char c = ke.getKeyChar();
        if (!Character.isISOControl(c)) {
            this.startTrans();
            this.append(c);
            this.endTrans();
            ke.consume();
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 8) {
            this.startTrans();
            this.deleteLastChar();
            this.endTrans();
            ke.consume();
        }
        if (ke.getKeyCode() == 10) {
            this.startTrans();
            this.append('\n');
            this.endTrans();
            ke.consume();
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    protected void calcBounds() {
        if (this._font == null) {
            return;
        }
        if (this._fm == null) {
            this._fm = Toolkit.getDefaultToolkit().getFontMetrics(this._font);
        }
        int overallW = 0;
        int numLines = 1;
        StringTokenizer lines = new StringTokenizer(this._curText, "\n\r", true);
        while (lines.hasMoreTokens()) {
            String curLine = lines.nextToken();
            int chunkW = this._fm.stringWidth(curLine);
            if (curLine.equals("\n") || curLine.equals("\r")) {
                ++numLines;
                continue;
            }
            overallW = Math.max(chunkW, overallW);
        }
        this._lineHeight = this._fm.getHeight();
        int maxDescent = this._fm.getMaxDescent();
        int overallH = (this._lineHeight + this._lineSpacing) * numLines + this._topMargin + this._botMargin + maxDescent;
        overallW = Math.max(30, overallW + this._leftMargin + this._rightMargin);
        switch (this._justification) {
            case 0: {
                break;
            }
            case 2: {
                if (this._w >= overallW) break;
                this._x -= (overallW - this._w) / 2;
                break;
            }
            case 1: {
                if (this._w >= overallW) break;
                this._x -= overallW - this._w;
            }
        }
        this._w = this._expandOnly ? Math.max(this._w, overallW) : overallW;
        this._h = this._expandOnly ? Math.max(this._h, overallH) : overallH;
    }

    static {
        PropCategoryManager.categorizeProperty("Text", "font");
        PropCategoryManager.categorizeProperty("Text", "underline");
        PropCategoryManager.categorizeProperty("Text", "expandOnly");
        PropCategoryManager.categorizeProperty("Text", "lineSpacing");
        PropCategoryManager.categorizeProperty("Text", "topMargin");
        PropCategoryManager.categorizeProperty("Text", "botMargin");
        PropCategoryManager.categorizeProperty("Text", "leftMargin");
        PropCategoryManager.categorizeProperty("Text", "rightMargin");
        PropCategoryManager.categorizeProperty("Text", "text");
        PropCategoryManager.categorizeProperty("Style", "justification");
        PropCategoryManager.categorizeProperty("Style", "textFilled");
        PropCategoryManager.categorizeProperty("Style", "textFillColor");
        PropCategoryManager.categorizeProperty("Style", "textColor");
    }
}

