/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import uci.gef.Fig;
import uci.gef.Geometry;
import uci.gef.Handle;
import uci.util.Dbg;

public class FigPoly
extends Fig {
    protected int _npoints = 0;
    protected int[] _xpoints = new int[4];
    protected int[] _ypoints = new int[4];
    protected boolean _rectilinear = false;
    protected int _fixedHandles = -1;
    private static Handle _TempHandle = new Handle(0);

    public FigPoly(Color lineColor) {
        this.setLineColor(lineColor);
    }

    public FigPoly(Color lineColor, Color fillColor) {
        this.setLineColor(lineColor);
        this.setFillColor(fillColor);
    }

    public FigPoly() {
    }

    public FigPoly(int x, int y) {
        this();
        this.addPoint(x, y);
    }

    public boolean OK() {
        return super.OK() && this._npoints > 0 && this._xpoints != null && this._ypoints != null;
    }

    public Polygon getPolygon() {
        return new Polygon(this._xpoints, this._ypoints, this._npoints);
    }

    public void setPolygon(Polygon p) {
        this._npoints = p.npoints;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        System.arraycopy(p.xpoints, 0, this._xpoints, 0, this._npoints);
        System.arraycopy(p.ypoints, 0, this._ypoints, 0, this._npoints);
        this.calcBounds();
    }

    public int getNumPoints() {
        return this._npoints;
    }

    public boolean getRectilinear() {
        return this._rectilinear;
    }

    public void setRectilinear(boolean r) {
        this._rectilinear = r;
    }

    public int getFixedHandles() {
        return this._fixedHandles;
    }

    public void setFixedHandles(int n) {
        this._fixedHandles = n;
    }

    public void setEndPoints(Point start, Point end) {
        while (this._npoints < 2) {
            this.addPoint(start);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigPoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, start.x, start.y, true);
            FigPoly._TempHandle.index = this._npoints - 1;
            this.moveVertex(_TempHandle, end.x, end.y, true);
        }
    }

    public void translate(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        int i = 0;
        while (i < this._npoints) {
            int n = i;
            this._xpoints[n] = this._xpoints[n] + dx;
            int n2 = i++;
            this._ypoints[n2] = this._ypoints[n2] + dy;
        }
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void addPoint(int x, int y) {
        this.growIfNeeded();
        this._xpoints[this._npoints] = x;
        this._ypoints[this._npoints] = y;
        ++this._npoints;
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public final void addPoint(Point p) {
        this.addPoint(p.x, p.y);
    }

    protected boolean canMoveVertex(int i, boolean ov) {
        return i >= 0 && i < this._npoints && (ov || i >= this._fixedHandles && i < this._npoints - this._fixedHandles);
    }

    public void moveVertex(Handle h, int x, int y, boolean ov) {
        int i = h.index;
        if (!this._rectilinear) {
            this._xpoints[i] = x;
            this._ypoints[i] = y;
        } else {
            if (ov) {
                this._xpoints[i] = x;
                this._ypoints[i] = y;
            }
            if (i == this._fixedHandles) {
                this.prependTwoPoints();
                h.index += 2;
                i += 2;
            }
            if (i == this._npoints - this._fixedHandles - 1) {
                this.appendTwoPoints();
            }
            if (i % 2 == 0) {
                if (this.canMoveVertex(i - 1, ov)) {
                    this._xpoints[i - 1] = x;
                    this._xpoints[i] = x;
                }
                if (this.canMoveVertex(i + 1, ov)) {
                    this._ypoints[i + 1] = y;
                    this._ypoints[i] = y;
                }
            } else {
                if (this.canMoveVertex(i - 1, ov)) {
                    this._ypoints[i - 1] = y;
                    this._ypoints[i] = y;
                }
                if (this.canMoveVertex(i + 1, ov)) {
                    this._xpoints[i + 1] = x;
                    this._xpoints[i] = x;
                }
            }
        }
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    protected void prependTwoPoints() {
        int[] tmp = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, tmp, 2, this._npoints);
        this._xpoints = tmp;
        tmp = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, tmp, 2, this._npoints);
        this._ypoints = tmp;
        this._xpoints[0] = this._xpoints[1] = this._xpoints[2];
        this._ypoints[0] = this._ypoints[1] = this._ypoints[2];
        this._npoints += 2;
    }

    protected void appendTwoPoints() {
        int[] tmp = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, tmp, 0, this._npoints);
        this._xpoints = tmp;
        tmp = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, tmp, 0, this._npoints);
        this._ypoints = tmp;
        this._xpoints[this._npoints + 1] = this._xpoints[this._npoints] = this._xpoints[this._npoints - 1];
        this._ypoints[this._npoints + 1] = this._ypoints[this._npoints] = this._ypoints[this._npoints - 1];
        this._npoints += 2;
    }

    public void removePoint(int i) {
        Dbg.assert(i >= 0 && i < this._npoints, "point not found");
        if (this._npoints < 3) {
            return;
        }
        int[] tmp = new int[this._npoints];
        if (this._rectilinear && i != 0 && i != this._npoints - 1) {
            if (i % 2 == 0) {
                this._xpoints[i] = this._xpoints[i + 1];
                this._ypoints[i] = this._ypoints[i - 1];
            } else {
                this._xpoints[i] = this._xpoints[i - 1];
                this._ypoints[i] = this._ypoints[i + 1];
            }
        } else {
            System.arraycopy(this._xpoints, i + 1, tmp, 0, this._npoints - i - 1);
            System.arraycopy(tmp, 0, this._xpoints, i, this._npoints - i - 1);
            System.arraycopy(this._ypoints, i + 1, tmp, 0, this._npoints - i - 1);
            System.arraycopy(tmp, 0, this._ypoints, i, this._npoints - i - 1);
            --this._npoints;
        }
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void insertPoint(int i, int x, int y) {
        this.growIfNeeded();
        int[] tmp = new int[this._npoints];
        System.arraycopy(this._xpoints, i + 1, tmp, 0, this._npoints - i - 1);
        this._xpoints[i + 1] = x;
        System.arraycopy(tmp, 0, this._xpoints, i + 2, this._npoints - i - 1);
        System.arraycopy(this._ypoints, i + 1, tmp, 0, this._npoints - i - 1);
        this._ypoints[i + 1] = y;
        System.arraycopy(tmp, 0, this._ypoints, i + 2, this._npoints - i - 1);
        ++this._npoints;
        this.calcBounds();
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] tmp = new int[this._npoints * 2];
            System.arraycopy(this._xpoints, 0, tmp, 0, this._npoints);
            this._xpoints = tmp;
            tmp = new int[this._npoints * 2];
            System.arraycopy(this._ypoints, 0, tmp, 0, this._npoints);
            this._ypoints = tmp;
        }
    }

    public Point getPoints(int i) {
        return new Point(this._xpoints[i], this._ypoints[i]);
    }

    public void setPoints(Handle h, int mX, int mY) {
        this.moveVertex(h, mX, mY, false);
    }

    public Point connectionPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this._xpoints, this._ypoints, this._npoints, anotherPt);
    }

    public void paint(Graphics g) {
        if (this._filled && this._fillColor != null) {
            g.setColor(this._fillColor);
            g.fillPolygon(this._xpoints, this._ypoints, this._npoints);
        }
        if (this._lineWidth > 0 && this._lineColor != null) {
            g.setColor(this._lineColor);
            g.drawPolyline(this._xpoints, this._ypoints, this._npoints);
        }
    }

    protected int findHandle(int x, int y) {
        int HAND_SIZE = 6;
        int[] xs = this._xpoints;
        int[] ys = this._ypoints;
        for (int i = 0; i < this._npoints; ++i) {
            if (x < xs[i] - HAND_SIZE / 2 || y < ys[i] - HAND_SIZE / 2 || x > xs[i] + HAND_SIZE / 2 || y > ys[i] + HAND_SIZE / 2) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int x, int y) {
        Polygon p = this.getPolygon();
        return p.contains(x, y);
    }

    public int[] getXs() {
        return this._xpoints;
    }

    public int[] getYs() {
        return this._ypoints;
    }

    public void setBounds(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        if (w > 0 && h > 0) {
            for (int i = 0; i < this._npoints; ++i) {
                this._xpoints[i] = x + (this._xpoints[i] - this._x) * w / this._w;
                this._ypoints[i] = y + (this._ypoints[i] - this._y) * h / this._h;
            }
            this._x = x;
            this._y = y;
            this._w = w;
            this._h = h;
            this.firePropChange("bounds", oldBounds, this.getBounds());
        }
    }

    public int getPerimeterLength() {
        int len = 0;
        for (int i = 0; i < this._npoints - 1; ++i) {
            int dx = this._xpoints[i + 1] - this._xpoints[i];
            int dy = this._ypoints[i + 1] - this._ypoints[i];
            len += (int)Math.sqrt(dx * dx + dy * dy);
        }
        return len;
    }

    public Point pointAlongPerimeter(int dist) {
        for (int i = 0; i < this._npoints - 1; ++i) {
            int dx = this._xpoints[i + 1] - this._xpoints[i];
            int dy = this._ypoints[i + 1] - this._ypoints[i];
            int segLen = (int)Math.sqrt(dx * dx + dy * dy);
            if (dist < segLen) {
                if (segLen != 0) {
                    return new Point(this._xpoints[i] + dx * dist / segLen, this._ypoints[i] + dy * dist / segLen);
                }
                return new Point(this._xpoints[i], this._ypoints[i]);
            }
            dist -= segLen;
        }
        return new Point(this._xpoints[0], this._ypoints[0]);
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isReshapable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    protected int countCornersContained(int x, int y, int w, int h) {
        Polygon p = this.getPolygon();
        int cornersHit = 0;
        if (p.contains(x, y)) {
            ++cornersHit;
        }
        if (p.contains(x + w, y)) {
            ++cornersHit;
        }
        if (p.contains(x, y + h)) {
            ++cornersHit;
        }
        if (p.contains(x + w, y + h)) {
            ++cornersHit;
        }
        return cornersHit;
    }

    protected void calcBounds() {
        Rectangle polyBounds = this.getPolygon().getBounds();
        this._x = polyBounds.x;
        this._y = polyBounds.y;
        this._w = polyBounds.width;
        this._h = polyBounds.height;
    }
}

