/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Fig;
import uci.gef.FigEdge;
import uci.gef.FigGroup;
import uci.gef.Globals;
import uci.graph.GraphNodeHooks;

public class FigNode
extends FigGroup
implements MouseListener,
PropertyChangeListener,
Serializable {
    public static final double ang45 = 0.7853981633974483;
    public static final double ang135 = 2.356194490192345;
    public static final double ang225 = 3.9269908169872414;
    public static final double ang315 = 5.497787143782138;
    protected boolean _blinkPorts = false;
    protected boolean _highlight = false;
    protected Vector _figEdges = new Vector();

    public FigNode(Object node) {
        this.setOwner(node);
        if (node instanceof GraphNodeHooks) {
            ((GraphNodeHooks)node).addPropertyChangeListener(this);
        }
    }

    public FigNode(Object node, Vector figs) {
        this(node);
        this.setFigs(figs);
    }

    public void setBlinkPorts(boolean b) {
        this._blinkPorts = b;
        this.hidePorts();
    }

    public boolean getBlinkPorts() {
        return this._blinkPorts;
    }

    public void addFigEdge(FigEdge fe) {
        this._figEdges.addElement(fe);
    }

    public void removeFigEdge(FigEdge fe) {
        this._figEdges.removeElement(fe);
    }

    public void setOwner(Object node) {
        Object oldOwner = this.getOwner();
        if (oldOwner != null && oldOwner instanceof GraphNodeHooks) {
            ((GraphNodeHooks)oldOwner).removePropertyChangeListener(this);
        }
        if (node instanceof GraphNodeHooks) {
            ((GraphNodeHooks)node).addPropertyChangeListener(this);
        }
        super.setOwner(node);
    }

    public void startTrans() {
        Enumeration arcPers = this._figEdges.elements();
        while (arcPers.hasMoreElements()) {
            Fig f = (Fig)arcPers.nextElement();
            f.startTrans();
        }
        super.startTrans();
    }

    public void endTrans() {
        Enumeration arcPers = this._figEdges.elements();
        while (arcPers.hasMoreElements()) {
            Fig f = (Fig)arcPers.nextElement();
            f.endTrans();
        }
        super.endTrans();
    }

    public void delete() {
        Enumeration arcPers = this._figEdges.elements();
        while (arcPers.hasMoreElements()) {
            Fig f = (Fig)arcPers.nextElement();
            f.delete();
        }
        super.delete();
    }

    public void dispose() {
        Enumeration arcPers = this._figEdges.elements();
        while (arcPers.hasMoreElements()) {
            Fig f = (Fig)arcPers.nextElement();
            f.dispose();
        }
        super.dispose();
    }

    public void bindPort(Object port, Fig f) {
        Fig oldPortFig = this.getPortFig(port);
        if (oldPortFig != null) {
            oldPortFig.setOwner(null);
        }
        f.setOwner(port);
    }

    public void removePort(Fig rep) {
        if (rep.getOwner() != null) {
            rep.setOwner(null);
        }
    }

    public final Object hitPort(Point p) {
        return this.hitPort(p.x, p.y);
    }

    public Object hitPort(int x, int y) {
        Fig f = this.hitFig(new Rectangle(x, y, 1, 1));
        if (f != null) {
            return f.getOwner();
        }
        return null;
    }

    public Object deepHitPort(int x, int y) {
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            Object own = f.getOwner();
            if (!f.contains(x, y) || own == null) continue;
            return own;
        }
        return null;
    }

    public Fig getPortFig(Object np) {
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (f.getOwner() != np) continue;
            return f;
        }
        return null;
    }

    public Vector getPortFigs() {
        Vector<Fig> res = new Vector<Fig>();
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (f.getOwner() == null) continue;
            res.addElement(f);
        }
        return res;
    }

    public int getPortSector(Fig portFig) {
        Rectangle nodeBBox = this.getBounds();
        Rectangle portBBox = portFig.getBounds();
        int nbbCenterX = nodeBBox.x + nodeBBox.width / 2;
        int nbbCenterY = nodeBBox.y + nodeBBox.height / 2;
        int pbbCenterX = portBBox.x + portBBox.width / 2;
        int pbbCenterY = portBBox.y + portBBox.height / 2;
        if (portFig != null) {
            int dx = (pbbCenterX - nbbCenterX) * nodeBBox.height;
            int dy = (pbbCenterY - nbbCenterY) * nodeBBox.width;
            double dist = Math.sqrt(dx * dx + dy * dy);
            double ang = dy > 0 ? Math.acos((double)dx / dist) : Math.acos((double)dx / dist) + Math.PI;
            if (ang < 0.7853981633974483) {
                return 2;
            }
            if (ang < 2.356194490192345) {
                return 1;
            }
            if (ang < 3.9269908169872414) {
                return -2;
            }
            if (ang < 5.497787143782138) {
                return -1;
            }
            return 2;
        }
        return -1;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this._highlight) {
            g.setColor(Globals.getPrefs().getHighlightColor());
            g.drawRect(this._x - 3, this._y - 3, this._w + 6 - 1, this._h + 6 - 1);
            g.drawRect(this._x - 2, this._y - 2, this._w + 4 - 1, this._h + 4 - 1);
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        System.out.println("FigNode got a PropertyChangeEvent");
        String pName = pce.getPropertyName();
        Object src = pce.getSource();
        if (pName.equals("Dispose") && src == this.getOwner()) {
            this.delete();
        }
        if (pName.equals("Highlight") && src == this.getOwner()) {
            this._highlight = (Boolean)pce.getNewValue();
            this.damage();
        }
    }

    public void showPorts() {
        this.startTrans();
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (f.getOwner() == null) continue;
            f.setLineWidth(1);
            f.setFilled(true);
        }
        this.endTrans();
    }

    public void hidePorts() {
        this.startTrans();
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (f.getOwner() == null) continue;
            f.setLineWidth(0);
            f.setFilled(false);
        }
        this.endTrans();
    }

    public void mouseEntered(MouseEvent me) {
        if (this._blinkPorts) {
            this.showPorts();
        }
    }

    public void mouseExited(MouseEvent me) {
        if (this._blinkPorts) {
            this.hidePorts();
        }
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    static {
        ang45 = 0.7853981633974483;
        ang135 = 2.356194490192345;
        ang225 = 3.9269908169872414;
        ang315 = 5.497787143782138;
    }
}

