/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import uci.gef.Fig;
import uci.gef.Globals;

public class FigImage
extends Fig
implements ImageObserver {
    protected transient Image _image;
    protected URL _url;

    public FigImage(int x, int y, int w, int h, Image img) {
        super(x, y, w, h);
        this._image = img;
    }

    public FigImage(int x, int y, Image i) {
        this(x, y, 0, 0, i);
        this.setWidth(i.getWidth(this));
        this.setHeight(i.getHeight(this));
    }

    public FigImage(int x, int y, URL imageUrl) {
        super(x, y, 0, 0);
        this._url = imageUrl;
        this._image = Globals.getImage(this._url);
        Globals.waitForImages();
        this._w = this._image.getWidth(this);
        this._h = this._image.getHeight(this);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean done = (infoflags & 0x70) != 0;
        return !done;
    }

    public void paint(Graphics g) {
        if (this._image == null) {
            System.out.println("reloading image");
            if (this._url != null) {
                this._image = Globals.getImage(this._url);
                Globals.waitForImages();
            }
        }
        if (this._image != null) {
            g.drawImage(this._image, this._x, this._y, this._w, this._h, this);
        } else {
            g.setColor(this._fillColor);
            g.fillRect(this._x, this._y, this._w, this._h);
        }
    }

    public void createDrag(int anchorX, int anchorY, int x, int y, int snapX, int snapY) {
        this.setLocation(snapX, snapY);
    }
}

