/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Fig;

public class FigGroup
extends Fig {
    protected Vector _figs;

    public FigGroup() {
        this._figs = new Vector();
    }

    public FigGroup(Vector figs) {
        this._figs = figs;
        this.calcBounds();
    }

    public Enumeration elements() {
        return this._figs.elements();
    }

    public void addFig(Fig p) {
        this._figs.addElement(p);
        this.calcBounds();
    }

    public Vector getFigs() {
        return this._figs;
    }

    public void setFigs(Vector figs) {
        Rectangle oldBounds = this.getBounds();
        this._figs = figs;
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void deleteFig(Fig p) {
        Rectangle oldBounds = this.getBounds();
        this._figs.removeElement(p);
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void removeAll() {
        Rectangle oldBounds = this.getBounds();
        this._figs.removeAllElements();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isRotatable() {
        return false;
    }

    public Fig hitFig(Rectangle r) {
        Enumeration figs = this.elements();
        Fig res = null;
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            if (!f.hit(r)) continue;
            res = f;
        }
        return res;
    }

    public boolean contains(int x, int y) {
        return this.hitFig(new Rectangle(x, y, 0, 0)) != null;
    }

    public boolean hit(Rectangle r) {
        return this.hitFig(r) != null;
    }

    public void translate(int dx, int dy) {
        Enumeration figs = this._figs.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            f.translate(dx, dy);
        }
        this._x += dx;
        this._y += dy;
    }

    public void setBounds(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        Enumeration figs = this._figs.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            int newX = this._w == 0 ? x : x + (f.getX() - this._x) * w / this._w;
            int newY = this._h == 0 ? y : y + (f.getY() - this._y) * h / this._h;
            int newW = this._w == 0 ? 0 : f.getWidth() * w / this._w;
            int newH = this._h == 0 ? 0 : f.getHeight() * h / this._h;
            f.setBounds(newX, newY, newW, newH);
        }
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void paint(Graphics g) {
        Enumeration figs = this.elements();
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            f.paint(g);
        }
    }

    public void calcBounds() {
        Enumeration figs = this._figs.elements();
        Rectangle bbox = figs.hasMoreElements() ? ((Fig)figs.nextElement()).getBounds() : new Rectangle(0, 0, 0, 0);
        while (figs.hasMoreElements()) {
            Fig f = (Fig)figs.nextElement();
            bbox.add(f.getBounds());
        }
        this._x = bbox.x;
        this._y = bbox.y;
        this._w = bbox.width;
        this._h = bbox.height;
    }
}

