/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import uci.gef.Fig;
import uci.gef.FigEdge;
import uci.gef.FigPoly;

public class FigEdgeRectiline
extends FigEdge {
    protected boolean _initiallyLaidOut = false;

    protected Fig makeEdgeFig() {
        FigPoly res = new FigPoly(Color.black);
        res.setRectilinear(true);
        res.setFixedHandles(1);
        res.setFilled(false);
        return res;
    }

    protected void computeRoute() {
        Point dstPt;
        Point srcPt;
        if (!this._initiallyLaidOut) {
            this.layoutEdge();
            this._initiallyLaidOut = true;
        }
        FigPoly p = (FigPoly)this._fig;
        if (this._useNearest) {
            srcPt = this._sourcePortFig.connectionPoint(p.getPoints(1));
            dstPt = this._destPortFig.connectionPoint(p.getPoints(p.getNumPoints() - 2));
        } else {
            srcPt = this._sourcePortFig.center();
            dstPt = this._destPortFig.center();
        }
        p.setEndPoints(srcPt, dstPt);
        this.calcBounds();
    }

    protected void layoutEdge() {
        int npoints = 0;
        int[] xpoints = new int[16];
        int[] ypoints = new int[16];
        Point srcPt = this._sourcePortFig.center();
        Point dstPt = this._destPortFig.center();
        if (this._useNearest) {
            srcPt = this._sourcePortFig.connectionPoint(dstPt);
            dstPt = this._destPortFig.connectionPoint(srcPt);
            srcPt = this._sourcePortFig.connectionPoint(dstPt);
            dstPt = this._destPortFig.connectionPoint(srcPt);
        }
        Rectangle srcRR = this._sourceFigNode.routingRect();
        Rectangle dstRR = this._destFigNode.routingRect();
        Object srcPort = this._sourcePortFig.getOwner();
        Object dstPort = this._destPortFig.getOwner();
        int srcSector = this._sourceFigNode.getPortSector(this._sourcePortFig);
        int dstSector = this._destFigNode.getPortSector(this._destPortFig);
        Point srcRRPt = this.routingRectPoint(srcPt, srcRR, srcSector);
        Point dstRRPt = this.routingRectPoint(dstPt, dstRR, dstSector);
        if (srcSector == 1 || srcSector == -1) {
            xpoints[npoints] = srcPt.x;
            ypoints[npoints++] = srcPt.y;
        }
        xpoints[npoints] = srcPt.x;
        ypoints[npoints++] = srcPt.y;
        xpoints[npoints] = srcRRPt.x;
        ypoints[npoints++] = srcRRPt.y;
        npoints += this.tryRoute(dstRRPt.x, dstRRPt.y, npoints, xpoints, ypoints, srcRR, dstRR, srcSector, dstSector);
        xpoints[npoints] = dstRRPt.x;
        ypoints[npoints++] = dstRRPt.y;
        xpoints[npoints] = dstPt.x;
        ypoints[npoints++] = dstPt.y;
        Polygon routePoly = new Polygon(xpoints, ypoints, npoints);
        ((FigPoly)this._fig).setPolygon(routePoly);
    }

    protected Point routingRectPoint(Point p, Rectangle r, int sector) {
        switch (sector) {
            case -1: {
                return new Point(p.x, r.y);
            }
            case 2: {
                return new Point(r.x, p.y);
            }
            case 1: {
                return new Point(p.x, r.y + r.height);
            }
            case -2: {
                return new Point(r.x + r.width, p.y);
            }
        }
        System.out.println("error, undefined sector!");
        return p;
    }

    protected int tryRoute(int x, int y, int np, int[] xs, int[] ys, Rectangle avoid1, Rectangle avoid2, int srcSector, int dstSector) {
        if (np > 12) {
            return 0;
        }
        int fx = xs[np - 1];
        int fy = ys[np - 1];
        if ((fx == x || fy == y) && this.segOK(fx, fy, x, y, avoid1, avoid2)) {
            xs[np] = x;
            ys[np++] = y;
            xs[np] = x;
            ys[np++] = y;
            return 1;
        }
        if (this.segOK(fx, fy, fx, y, avoid1, avoid2) && this.segOK(fx, y, x, y, avoid1, avoid2)) {
            xs[np] = fx;
            ys[np++] = y;
            xs[np] = x;
            ys[np++] = y;
            return 2;
        }
        if (this.segOK(fx, fy, x, fy, avoid1, avoid2) && this.segOK(x, fy, x, y, avoid1, avoid2)) {
            xs[np] = x;
            ys[np++] = fy;
            xs[np] = x;
            ys[np++] = y;
            return 2;
        }
        Point avoidPt = this.findAvoidPt(fx, fy, x, y, avoid1, avoid2);
        if ((srcSector == 1 || srcSector == -1 || fy == avoidPt.y) && fx != avoidPt.x) {
            xs[np] = avoidPt.x;
            ys[np++] = fy;
            return this.tryRoute(x, y, np, xs, ys, avoid1, avoid2, srcSector, dstSector) + 1;
        }
        if ((srcSector == 2 || srcSector == -2 || fx == avoidPt.x) && fy != avoidPt.y) {
            xs[np] = fx;
            ys[np++] = avoidPt.y;
            return this.tryRoute(x, y, np, xs, ys, avoid1, avoid2, srcSector, dstSector) + 1;
        }
        return 0;
    }

    protected Point findAvoidPt(int fx, int fy, int x, int y, Rectangle avoid1, Rectangle avoid2) {
        Point res = new Point(fx, fy);
        res.x = avoid1.x + avoid1.width < avoid2.x ? avoid2.x : (avoid2.x + avoid2.width < avoid1.x ? avoid1.x : Math.min(avoid1.x, avoid2.x));
        res.y = avoid1.y + avoid1.height < avoid2.y ? avoid2.y : (avoid2.y + avoid2.height < avoid1.y ? avoid1.y : Math.min(avoid1.y, avoid2.y));
        return res;
    }

    protected boolean segOK(int x1, int y1, int x2, int y2, Rectangle avoid1, Rectangle avoid2) {
        int xmin = Math.min(x1, x2);
        int xmax = Math.max(x1, x2);
        int ymin = Math.min(y1, y2);
        int ymax = Math.max(y1, y2);
        int rright = avoid1.x + avoid1.width;
        int rbot = avoid1.y + avoid1.height;
        if (x1 == x2 && x1 > avoid1.x && x1 < rright && (ymin < avoid1.y && ymax > avoid1.y || ymin < rbot && ymax > rbot)) {
            return false;
        }
        if (y1 == y2 && y1 > avoid1.y && y1 < rbot && (xmin < avoid1.x && xmax > avoid1.x || xmin < rright && xmax > rright)) {
            return false;
        }
        rright = avoid2.x + avoid2.width;
        rbot = avoid2.y + avoid2.height;
        if (x1 == x2 && x1 > avoid2.x && x1 < rright && (ymin < avoid2.y && ymax > avoid2.y || ymin < rbot && ymax > rbot)) {
            return false;
        }
        return y1 != y2 || y1 <= avoid2.y || y1 >= rbot || (xmin >= avoid2.x || xmax <= avoid2.x) && (xmin >= rright || xmax <= rright);
    }
}

