/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.util.Enumeration;
import uci.gef.Cmd;
import uci.gef.CmdShowURL;
import uci.gef.Editor;
import uci.gef.Globals;

public class ExecuteCmdWindow
extends Frame {
    List _cmdNames = new List();
    Button _execute = new Button("Execute");
    Button _about = new Button("About");
    Button _close = new Button("Close");

    public ExecuteCmdWindow() {
        Enumeration acts = Cmd.registeredCmds();
        while (acts.hasMoreElements()) {
            Cmd a = (Cmd)acts.nextElement();
            this._cmdNames.addItem(a.getName());
        }
        ((Component)this).setBackground(Color.white);
        this.add("Center", this._cmdNames);
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout());
        buttons.add(this._execute);
        buttons.add(this._about);
        this._execute.setEnabled(false);
        this._about.setEnabled(false);
        buttons.add(this._close);
        this.add("South", buttons);
        this.pack();
        Dimension d = this.getSize();
        ((Component)this).setSize(d.width, Math.min(d.height * 2, 350));
    }

    public boolean handleEvent(Event e) {
        switch (e.id) {
            case 201: {
                if (e.target != this) break;
                this.close();
                return true;
            }
            case 701: {
                this._execute.setEnabled(true);
                this._about.setEnabled(true);
                return true;
            }
            case 702: {
                this._execute.setEnabled(false);
                this._about.setEnabled(false);
                return true;
            }
        }
        return super.handleEvent(e);
    }

    public boolean getCmd(Event e, Object what) {
        if (e.target == this._close) {
            this.close();
            return true;
        }
        if (e.target == this._execute) {
            this.executeCommand(e);
            return true;
        }
        if (e.target == this._about) {
            this.describeCommand();
            return true;
        }
        if (e.target == this._cmdNames) {
            this.executeCommand(e);
            return true;
        }
        return false;
    }

    public void close() {
        this.dispose();
    }

    protected void executeCommand(Event e) {
        Editor ce = Globals.curEditor();
        System.out.println("executing: ".concat(String.valueOf(String.valueOf(this._cmdNames.getSelectedItem()))));
        Cmd act = Cmd.cmdAtIndex(this._cmdNames.getSelectedIndex());
        ce.executeCmd(act, null);
    }

    protected void describeCommand() {
        Editor ce = Globals.curEditor();
        Cmd act = Cmd.cmdAtIndex(this._cmdNames.getSelectedIndex());
        CmdShowURL showIt = null;
        try {
            showIt = new CmdShowURL(act.about());
        }
        catch (Exception e) {
            System.out.println("malformed?");
        }
        ce.executeCmd(showIt, null);
    }
}

