/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import uci.gef.Cmd;
import uci.gef.Diagram;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Guide;
import uci.gef.GuideGrid;
import uci.gef.Layer;
import uci.gef.LayerDiagram;
import uci.gef.LayerManager;
import uci.gef.LayerPerspective;
import uci.gef.Mode;
import uci.gef.ModeManager;
import uci.gef.ModePopup;
import uci.gef.ModeSelect;
import uci.gef.Nodo;
import uci.gef.RedrawManager;
import uci.gef.Selection;
import uci.gef.SelectionManager;
import uci.gef.event.GraphSelectionListener;
import uci.graph.GraphEdgeRenderer;
import uci.graph.GraphModel;
import uci.graph.GraphNodeRenderer;

public class Editor
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final int GRIP_SIZE = 8;
    protected ModeManager _modeManager = new ModeManager(this);
    protected Object _document;
    protected SelectionManager _selectionManager = new SelectionManager(this);
    protected LayerManager _layerManager = new LayerManager(this);
    protected Guide _guide = new GuideGrid(8);
    protected Fig _curFig = null;
    private transient Component _awt_component;
    protected transient RedrawManager _redrawer = new RedrawManager(this);
    protected static Rectangle _hitRect;

    public Editor(GraphModel gm, Component awt_comp) {
        this(gm, awt_comp, null);
    }

    public Editor(GraphModel gm) {
        this(gm, null, null);
    }

    public Editor() {
        this(null, null, null);
    }

    public Editor(Diagram d) {
        this(d.getGraphModel(), null, d.getLayer());
    }

    public Editor(GraphModel gm, Component awt_comp, Layer lay) {
        this._awt_component = awt_comp;
        this.defineLayers(gm, lay);
        this.mode(new ModeSelect(this));
        this.mode(new ModePopup(this));
        Globals.curEditor(this);
    }

    protected void defineLayers(GraphModel gm, Layer lay) {
        this._layerManager.addLayer(new LayerDiagram());
        if (lay != null) {
            this._layerManager.addLayer(lay);
        } else if (gm == null) {
            this._layerManager.addLayer(new LayerDiagram("Example"));
        } else {
            this._layerManager.addLayer(new LayerPerspective("untitled", gm));
        }
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public void postLoad() {
        if (this._redrawer == null) {
            this._redrawer = new RedrawManager(this);
        }
    }

    public Object clone() {
        try {
            Editor ed = (Editor)this.getClass().newInstance();
            ed.getLayerManager().addLayer(this._layerManager.getActiveLayer());
            ed.document(this.document());
            Editor editor = ed;
            return editor;
        }
        catch (IllegalAccessException ignore) {
            System.out.println("IllegalAccessException in spawn");
        }
        catch (InstantiationException ignore) {
            System.out.println("InstantiationException in spawn");
        }
        return null;
    }

    public void mode(Mode m) {
        this._modeManager.push(m);
        m.setEditor(this);
        Globals.showStatus(m.instructions());
    }

    public void finishMode() {
        this._modeManager.pop();
        this.mode(Globals.mode());
        Globals.clearStatus();
    }

    public LayerManager getLayerManager() {
        return this._layerManager;
    }

    public GraphModel getGraphModel() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphModel();
        }
        return null;
    }

    public void setGraphModel(GraphModel gm) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphModel(gm);
        }
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphNodeRenderer();
        }
        return null;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer rend) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphNodeRenderer(rend);
        }
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            return ((LayerPerspective)active).getGraphEdgeRenderer();
        }
        return null;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer rend) {
        Layer active = this._layerManager.getActiveLayer();
        if (active instanceof LayerPerspective) {
            ((LayerPerspective)active).setGraphEdgeRenderer(rend);
        }
    }

    public Enumeration figs() {
        return this._layerManager.elements();
    }

    public void add(Fig f) {
        this.getLayerManager().add(f);
    }

    public void remove(Fig f) {
        this.getLayerManager().remove(f);
    }

    public final Fig hit(Point p) {
        _hitRect.setLocation(p.x - 4, p.y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int x, int y) {
        _hitRect.setLocation(x - 4, y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int x, int y, int w, int h) {
        return this.hit(new Rectangle(x, y, w, h));
    }

    public Fig hit(Rectangle r) {
        return this.getLayerManager().hit(r);
    }

    protected void setUnderMouse(MouseEvent me) {
        int y;
        Object node = null;
        int x = me.getX();
        Fig f = this.hit(x, y = me.getY());
        if (f != this._curFig) {
            if (this._curFig instanceof MouseListener) {
                ((MouseListener)((Object)this._curFig)).mouseExited(me);
            }
            if (f instanceof MouseListener) {
                ((MouseListener)((Object)f)).mouseEntered(me);
            }
        }
        this._curFig = f;
    }

    public Object document() {
        return this._document;
    }

    public void document(Object d) {
        this._document = d;
    }

    public void snap(Point p) {
        if (this._guide != null) {
            this._guide.snap(p);
        }
    }

    public Guide getGuide() {
        return this._guide;
    }

    public void setGuide(Guide g) {
        this._guide = g;
    }

    public void damaged(Rectangle r) {
        this._redrawer.add(r);
    }

    public void damaged(Fig f) {
        if (this._redrawer == null) {
            this._redrawer = new RedrawManager(this);
        }
        if (f != null) {
            this._redrawer.add(f);
        }
    }

    public void damaged(Selection sel) {
        if (sel != null) {
            this._redrawer.add(sel);
        }
    }

    public void damageAll() {
        if (this._redrawer == null) {
            this._redrawer = new RedrawManager(this);
        }
        Dimension size = this.getAwtComponent().getSize();
        this._redrawer.add(new Rectangle(0, 0, size.width, size.height));
    }

    public void repairDamage() {
        this._redrawer.repairDamage();
    }

    public synchronized void paint(Graphics g) {
        this.getLayerManager().paint(g);
        this._selectionManager.paint(g);
        this._modeManager.paint(g);
    }

    public synchronized void print(Graphics g) {
        this.getLayerManager().paint(g);
    }

    public SelectionManager getSelectionManager() {
        return this._selectionManager;
    }

    public Component getAwtComponent() {
        return this._awt_component;
    }

    public void setAwtComponent(Component c) {
        this._awt_component = c;
    }

    public void setCursor(Cursor c) {
        if (this.getAwtComponent() != null) {
            this.getAwtComponent().setCursor(c);
        }
    }

    public Graphics getGraphics() {
        if (this._awt_component == null) {
            return null;
        }
        return this._awt_component.getGraphics();
    }

    public Frame findFrame() {
        Component c;
        for (c = this._awt_component; c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    public Image createImage(int w, int h) {
        if (this._awt_component == null) {
            return null;
        }
        try {
            if (this._awt_component.getPeer() == null) {
                this._awt_component.addNotify();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this._awt_component.createImage(w, h);
    }

    public Color getBackground() {
        if (this._awt_component == null) {
            return Color.lightGray;
        }
        return this._awt_component.getBackground();
    }

    public void addGraphSelectionListener(GraphSelectionListener listener2) {
        this._selectionManager.addGraphSelectionListener(listener2);
    }

    public void removeGraphSelectionListener(GraphSelectionListener listener2) {
        this._selectionManager.removeGraphSelectionListener(listener2);
    }

    public void mouseClicked(MouseEvent me) {
        Object sel;
        Vector sels;
        if (me.getClickCount() == 1) {
            RedrawManager.lock();
            Globals.curEditor(this);
            this._selectionManager.mouseClicked(me);
            this._modeManager.mouseClicked(me);
            RedrawManager.unlock();
            this._redrawer.repairDamage();
        }
        if (me.getClickCount() == 2 && (sels = this._selectionManager.getFigs()).size() == 1 && (sel = sels.elementAt(0)).getClass().getName().compareTo("uci.gef.Nodo") == 0) {
            Nodo nodo = (Nodo)sel;
            nodo.dobleClick(nodo.identificador());
        }
    }

    public void mousePressed(MouseEvent me) {
        RedrawManager.lock();
        Globals.curEditor(this);
        this._selectionManager.mousePressed(me);
        this._modeManager.mousePressed(me);
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void mouseReleased(MouseEvent me) {
        RedrawManager.lock();
        Globals.curEditor(this);
        this._selectionManager.mouseReleased(me);
        this._modeManager.mouseReleased(me);
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void mouseEntered(MouseEvent me) {
        if (this._awt_component != null) {
            this._awt_component.requestFocus();
        }
        RedrawManager.lock();
        Globals.curEditor(this);
        this.mode(Globals.mode());
        this.setUnderMouse(me);
        this._modeManager.mouseEntered(me);
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void mouseExited(MouseEvent me) {
        RedrawManager.lock();
        this.setUnderMouse(me);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseExited(me);
        }
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void mouseDragged(MouseEvent me) {
        Object nextEvent = null;
        RedrawManager.lock();
        Globals.curEditor(this);
        this.setUnderMouse(me);
        this._selectionManager.mouseDragged(me);
        this._modeManager.mouseDragged(me);
        RedrawManager.unlock();
        if (nextEvent == null) {
            this._redrawer.repairDamage();
        }
    }

    public void mouseMoved(MouseEvent me) {
        Object nextEvent = null;
        RedrawManager.lock();
        Globals.curEditor(this);
        this.setUnderMouse(me);
        this._selectionManager.mouseMoved(me);
        this._modeManager.mouseMoved(me);
        RedrawManager.unlock();
        if (nextEvent == null) {
            this._redrawer.repairDamage();
        }
    }

    public void keyTyped(KeyEvent ke) {
        RedrawManager.lock();
        Globals.curEditor(this);
        this._selectionManager.keyTyped(ke);
        this._modeManager.keyTyped(ke);
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void keyPressed(KeyEvent ke) {
        RedrawManager.lock();
        Globals.curEditor(this);
        this._selectionManager.keyPressed(ke);
        this._modeManager.keyPressed(ke);
        RedrawManager.unlock();
        this._redrawer.repairDamage();
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void executeCmd(Cmd c, InputEvent ie) {
        if (c == null) {
            return;
        }
        try {
            c.doIt();
        }
        catch (Throwable ex) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("While executing ").append(c).append(" on event ").append(ie).append(" the following error occured:"))));
            ex.printStackTrace();
        }
    }

    public void removed(Fig f) {
        this._selectionManager.deselect(f);
        this.remove(f);
    }

    static {
        GRIP_SIZE = 8;
        _hitRect = new Rectangle(0, 0, 8, 8);
    }
}

