/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.util.Vector;
import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Fig;
import uci.gef.Globals;
import uci.gef.Selection;
import uci.gef.SelectionManager;

public class CmdSelectNext
extends Cmd {
    public static final String DIR = "Direction";
    public static final String DIR_NEXT = "Next";
    public static final String DIR_PREV = "Previous";

    public CmdSelectNext() {
        this(true);
    }

    public CmdSelectNext(boolean next) {
        this(next ? DIR_NEXT : DIR_PREV);
    }

    public CmdSelectNext(String d) {
        super("Select ".concat(String.valueOf(String.valueOf(d))));
        this.setArg(DIR, d);
    }

    public void doIt() {
        block5: {
            Fig newFig = null;
            int offset = 1;
            String dir = (String)this.getArg(DIR);
            if (DIR_PREV.equals(dir)) {
                offset = -1;
            }
            Editor ce = Globals.curEditor();
            SelectionManager sm = ce.getSelectionManager();
            Vector diagramContents = ce.getLayerManager().getContents();
            int diagramSize = diagramContents.size();
            int newIndex = diagramSize + 1;
            if (sm.size() == 0) {
                newIndex = 0;
            } else if (sm.size() == 1) {
                Selection curSel = (Selection)sm.selections().firstElement();
                Fig curFig = curSel.getContent();
                int curIndex = diagramContents.indexOf(curFig);
                newIndex = (curIndex + offset + diagramSize) % diagramSize;
            }
            if (diagramSize > newIndex) {
                newFig = (Fig)diagramContents.elementAt(newIndex);
            }
            if (newFig == null) break block5;
            ce.getSelectionManager().select(newFig);
        }
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSelectNext");
    }

    static {
        DIR = DIR;
        DIR_NEXT = DIR_NEXT;
        DIR_PREV = DIR_PREV;
    }
}

