/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Globals;

public class CmdSave
extends Cmd
implements FilenameFilter {
    public CmdSave() {
        super("Save...");
    }

    public CmdSave(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    public void doIt() {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(".");
            fd.show();
            String filename = fd.getFile();
            String path = fd.getDirectory();
            if (filename != null) {
                Globals.showStatus(String.valueOf(String.valueOf(new StringBuffer("Writing ").append(path).append(filename).append("..."))));
                FileOutputStream f = new FileOutputStream(String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(filename))));
                ObjectOutputStream s = new ObjectOutputStream(f);
                System.out.println("Cmd save...");
                ce.preSave();
                s.writeObject(ce);
                ce.postSave();
                System.out.println("save done");
                Globals.showStatus(String.valueOf(String.valueOf(new StringBuffer("Wrote ").append(path).append(filename))));
                f.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
    }

    public boolean accept(File dir, String name) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("checking: ").append(dir).append(" ").append(name))));
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }
}

