/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import uci.gef.Cmd;
import uci.gef.Editor;
import uci.gef.Globals;
import uci.gef.SelectionManager;

public class CmdNudge
extends Cmd {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int _direction;
    private int _magnitude;

    public CmdNudge(int dir) {
        this(dir, 1);
    }

    public CmdNudge(int dir, int mag) {
        super("Nudge ".concat(String.valueOf(String.valueOf(CmdNudge.wordFor(dir)))));
        this._direction = dir;
        this._magnitude = mag;
    }

    protected static String wordFor(int d) {
        switch (d) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int dx = 0;
        int dy = 0;
        switch (this._direction) {
            case 1: {
                dx = 0 - this._magnitude;
                break;
            }
            case 2: {
                dx = this._magnitude;
                break;
            }
            case 3: {
                dy = 0 - this._magnitude;
                break;
            }
            case 4: {
                dy = this._magnitude;
            }
        }
        sm.startTrans();
        sm.translate(dx, dy);
        sm.endTrans();
    }

    public void undoIt() {
        System.out.println("Cannot undo CmdNudge, yet.");
    }

    static {
        LEFT = 1;
        RIGHT = 2;
        UP = 3;
        DOWN = 4;
    }
}

