/*
 * Decompiled with CFR 0.152.
 */
package uci.gef;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public abstract class ArrowHead {
    protected final int arrow_width = 7;
    protected final int arrow_height = 12;
    protected Color arrowLineColor = Color.black;
    protected Color arrowFillColor = Color.black;

    public Color getLineColor() {
        return this.arrowLineColor;
    }

    public void setLineColor(Color newColor) {
        this.arrowLineColor = newColor;
    }

    public Color getFillColor() {
        return this.arrowFillColor;
    }

    public void setFillColor(Color newColor) {
        this.arrowFillColor = newColor;
    }

    public abstract void paint(Graphics var1, Point var2, Point var3);

    public int getLineLength(Point one, Point two) {
        int dxdx = (two.x - one.x) * (two.x - one.x);
        int dydy = (two.y - one.y) * (two.y - one.y);
        return (int)Math.sqrt(dxdx + dydy);
    }

    public Point pointAlongLine(Point one, Point two, int dist) {
        int len = this.getLineLength(one, two);
        int p = dist;
        if (len == 0) {
            return one;
        }
        return new Point(one.x + (two.x - one.x) * p / len, one.y + (two.y - one.y) * p / len);
    }
}

