/*
 * Decompiled with CFR 0.152.
 */
package uci.beans.editors;

import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RectangleEditor
extends JPanel
implements PropertyEditor {
    protected Rectangle _rect = null;
    private Vector listeners;
    protected JTextField xField;
    protected JTextField yField;
    protected JTextField wField;
    protected JTextField hField;

    public RectangleEditor() {
        this.setLayout(new GridLayout(1, 4));
        this.resize(this.insets().left + this.insets().right + 20, this.insets().top + this.insets().bottom + 20);
        this.xField = new JTextField("0", 4);
        this.yField = new JTextField("0", 4);
        this.hField = new JTextField("0", 4);
        this.wField = new JTextField("0", 4);
        this.add(this.xField);
        this.add(this.yField);
        this.add(this.hField);
        this.add(this.wField);
    }

    public void setValue(Object v) {
        if (!(v instanceof Rectangle)) {
            return;
        }
        this._rect = (Rectangle)v;
        this.updateWidgets();
    }

    public Object getValue() {
        return this._rect;
    }

    public String getJavaInitializationString() {
        return String.valueOf(String.valueOf(new StringBuffer("new Rectangle(").append(this.getAsText()).append(")")));
    }

    public String getAsText() {
        Rectangle r = (Rectangle)this.getValue();
        return String.valueOf(String.valueOf(new StringBuffer("").append(r.x).append(", ").append(r.y).append(", ").append(r.width).append(", ").append(r.height)));
    }

    public void setAsText(String text) {
    }

    public String[] getTags() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle box) {
        Rectangle r = (Rectangle)this.getValue();
        String rectString = String.valueOf(String.valueOf(new StringBuffer("(").append(r.x).append(",").append(r.y).append(")+(").append(r.width).append("x").append(r.height).append(" )")));
        g.drawString(rectString, box.x + 2, box.x + box.height - 4);
    }

    public void enable() {
        this.xField.setEditable(true);
        this.yField.setEditable(true);
        this.wField.setEditable(true);
        this.hField.setEditable(true);
    }

    public void disable() {
        this.xField.setEditable(false);
        this.yField.setEditable(false);
        this.wField.setEditable(false);
        this.hField.setEditable(false);
    }

    public void updateWidgets() {
        this.xField.setText(Integer.toString(this._rect.x));
        this.yField.setText(Integer.toString(this._rect.y));
        this.wField.setText(Integer.toString(this._rect.width));
        this.hField.setText(Integer.toString(this._rect.height));
    }

    protected void readFields() {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            int width = Integer.parseInt(this.wField.getText());
            int height = Integer.parseInt(this.hField.getText());
            this.setValue(new Rectangle(x, y, width, height));
        }
        catch (NumberFormatException ignore) {
            this.updateWidgets();
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target != this && event.id == 1001) {
            this.readFields();
            return true;
        }
        return super.handleEvent(event);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener2) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener2);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener2) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener2);
    }

    public void firePropertyChange() {
        Vector targets;
        RectangleEditor rectangleEditor = this;
        synchronized (rectangleEditor) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }
}

