/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.awt.Rectangle;
import java.util.Vector;
import jclass.util.JCPointRect;
import jclass.util.JCRectList;
import jclass.util.JCRectNode;
import jclass.util.JCRectSortLR;
import jclass.util.JCRectSortTB;
import jclass.util.JCSortInterface;
import jclass.util.JCqsort;

public class JCRectUtil {
    public static final int LEFTTORIGHT = 0;
    public static final int TOPTOBOTTOM = 1;

    static void appendrect(Rectangle rectangle, JCRectList jCRectList) {
        JCRectNode jCRectNode = new JCRectNode();
        jCRectNode.rect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        JCRectUtil.appendrectnode(jCRectNode, jCRectList);
    }

    static void appendrectnode(JCRectNode jCRectNode, JCRectList jCRectList) {
        jCRectNode.next = null;
        if (jCRectList.head == null) {
            jCRectList.head = jCRectNode;
        }
        if (jCRectList.tail != null) {
            jCRectList.tail.next = jCRectNode;
        }
        jCRectList.tail = jCRectNode;
    }

    static void appendremaining(Rectangle rectangle, Rectangle rectangle2, JCRectList jCRectList) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle3 = new Rectangle();
        if (JCRectUtil.includesrect(rectangle, rectangle2)) {
            return;
        }
        if (!rectangle.intersects(rectangle2)) {
            JCRectUtil.appendrect(rectangle2, jCRectList);
            return;
        }
        Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        int n4 = rectangle.y - rectangle4.y;
        if (n4 > 0) {
            rectangle3.x = rectangle4.x;
            rectangle3.y = rectangle4.y;
            rectangle3.width = rectangle4.width;
            rectangle3.height = n4;
            JCRectUtil.appendrect(rectangle3, jCRectList);
            rectangle4.y += n4;
            rectangle4.height -= n4;
        }
        if ((n4 = rectangle4.y + rectangle4.height - (n3 = rectangle.y + rectangle.height)) > 0) {
            rectangle3.x = rectangle4.x;
            rectangle3.y = n3;
            rectangle3.width = rectangle4.width;
            rectangle3.height = n4;
            JCRectUtil.appendrect(rectangle3, jCRectList);
            rectangle4.height -= n4;
        }
        if ((n2 = rectangle.x - rectangle4.x) > 0) {
            rectangle3.x = rectangle4.x;
            rectangle3.y = rectangle4.y;
            rectangle3.width = n2;
            rectangle3.height = rectangle4.height;
            JCRectUtil.appendrect(rectangle3, jCRectList);
            rectangle4.x += n2;
            rectangle4.width -= n2;
        }
        if ((n2 = rectangle4.x + rectangle4.width - (n = rectangle.x + rectangle.width)) > 0) {
            rectangle3.x = n;
            rectangle3.y = rectangle4.y;
            rectangle3.width = n2;
            rectangle3.height = rectangle4.height;
            JCRectUtil.appendrect(rectangle3, jCRectList);
            rectangle4.width -= n2;
        }
    }

    static Rectangle bounding(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = new Rectangle();
        if (JCRectUtil.isnull(rectangle)) {
            rectangle3 = rectangle2;
        } else if (JCRectUtil.isnull(rectangle2)) {
            rectangle3 = rectangle;
        } else {
            rectangle3.x = Math.min(rectangle.x, rectangle2.x);
            rectangle3.y = Math.min(rectangle.y, rectangle2.y);
            rectangle3.width = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - rectangle3.x;
            rectangle3.height = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - rectangle3.y;
        }
        return rectangle3;
    }

    static void calc_lg_rect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        JCPointRect jCPointRect = new JCPointRect();
        JCPointRect jCPointRect2 = new JCPointRect();
        JCPointRect jCPointRect3 = new JCPointRect();
        JCPointRect jCPointRect4 = new JCPointRect();
        jCPointRect.x1 = rectangle2.x;
        jCPointRect.x2 = rectangle2.width + rectangle2.x - 1;
        jCPointRect.y1 = rectangle2.y;
        jCPointRect.y2 = rectangle2.height + rectangle2.y - 1;
        jCPointRect2.x1 = rectangle3.x;
        jCPointRect2.x2 = rectangle3.width + rectangle3.x - 1;
        jCPointRect2.y1 = rectangle3.y;
        jCPointRect2.y2 = rectangle3.height + rectangle3.y - 1;
        jCPointRect3.x1 = rectangle.x;
        jCPointRect3.x2 = rectangle.width + rectangle.x - 1;
        jCPointRect3.y1 = rectangle.y;
        jCPointRect3.y2 = rectangle.height + rectangle.y - 1;
        double d = JCRectUtil.lg_metric(jCPointRect3);
        if (jCPointRect.x1 == jCPointRect2.x1 && jCPointRect.x2 == jCPointRect2.x2 && jCPointRect.y1 == jCPointRect2.y1 && jCPointRect.y2 == jCPointRect2.y2) {
            double d2 = JCRectUtil.lg_metric(jCPointRect);
            if (d2 > d) {
                rectangle.x = rectangle2.x;
                rectangle.y = rectangle2.y;
                rectangle.width = rectangle2.width;
                rectangle.height = rectangle2.height;
            }
        } else if (Math.abs(jCPointRect.y2 - jCPointRect2.y1) == 1) {
            jCPointRect4.x1 = Math.max(jCPointRect.x1, jCPointRect2.x1);
            jCPointRect4.x2 = Math.min(jCPointRect.x2, jCPointRect2.x2);
            jCPointRect4.y1 = jCPointRect.y1;
            jCPointRect4.y2 = jCPointRect2.y2;
            if (jCPointRect4.x1 <= jCPointRect4.x2) {
                rectangle2.x = jCPointRect4.x1;
                rectangle2.y = jCPointRect4.y1;
                rectangle2.width = jCPointRect4.x2 - jCPointRect4.x1 + 1;
                rectangle2.height = jCPointRect4.y2 - jCPointRect4.y1 + 1;
                double d3 = JCRectUtil.lg_metric(jCPointRect4);
                if (d3 > d) {
                    rectangle.x = rectangle2.x;
                    rectangle.y = rectangle2.y;
                    rectangle.width = rectangle2.width;
                    rectangle.height = rectangle2.height;
                }
            }
        } else if (Math.abs(jCPointRect.x2 - jCPointRect2.x1) == 1) {
            jCPointRect4.x1 = jCPointRect.x1;
            jCPointRect4.x2 = jCPointRect2.x2;
            jCPointRect4.y1 = Math.max(jCPointRect.y1, jCPointRect2.y1);
            jCPointRect4.y2 = Math.min(jCPointRect.y2, jCPointRect2.y2);
            if (jCPointRect4.y1 <= jCPointRect4.y2) {
                rectangle2.x = jCPointRect4.x1;
                rectangle2.y = jCPointRect4.y1;
                rectangle2.width = jCPointRect4.x2 - jCPointRect4.x1 + 1;
                rectangle2.height = jCPointRect4.y2 - jCPointRect4.y1 + 1;
                double d4 = JCRectUtil.lg_metric(jCPointRect4);
                if (d4 > d) {
                    rectangle.x = rectangle2.x;
                    rectangle.y = rectangle2.y;
                    rectangle.width = rectangle2.width;
                    rectangle.height = rectangle2.height;
                }
            }
        }
    }

    static boolean includesrect(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x <= rectangle2.x && rectangle.y <= rectangle2.y && rectangle.x + rectangle.width >= rectangle2.x + rectangle2.width && rectangle.y + rectangle.height >= rectangle2.y + rectangle2.height;
    }

    static void intersect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (rectangle == null || rectangle2 == null || rectangle3 == null) {
            return;
        }
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        if (JCRectUtil.isnull(rectangle) || JCRectUtil.isnull(rectangle2)) {
            return;
        }
        rectangle3.x = Math.max(rectangle.x, rectangle2.x);
        rectangle3.y = Math.max(rectangle.y, rectangle2.y);
        int n = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n2 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        rectangle3.width = Math.max(n - rectangle3.x, 0);
        rectangle3.height = Math.max(n2 - rectangle3.y, 0);
    }

    static boolean isnull(Rectangle rectangle) {
        return rectangle.width == 0 || rectangle.height == 0;
    }

    public static Rectangle largest_rect(JCRectList jCRectList) {
        JCRectList[] jCRectListArray = null;
        JCRectUtil.normalize(jCRectList);
        JCRectUtil.sort(jCRectList, jCRectList, 1);
        jCRectListArray = JCRectUtil.make(jCRectList);
        Rectangle rectangle = jCRectListArray[0].head.rect;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 0;
        JCRectList jCRectList2 = jCRectListArray[n];
        while (jCRectList2.head != null) {
            JCRectNode jCRectNode = jCRectList2.head;
            while (jCRectNode != null) {
                Rectangle rectangle3 = new Rectangle(jCRectNode.rect.x, jCRectNode.rect.y, jCRectNode.rect.width, jCRectNode.rect.height);
                JCRectUtil.search_lg_rect(jCRectListArray, n, jCRectNode, rectangle2, rectangle3);
                jCRectNode = jCRectNode.next;
            }
            jCRectList2 = jCRectListArray[++n];
        }
        return rectangle2;
    }

    static double lg_metric(JCPointRect jCPointRect) {
        return (double)(jCPointRect.x2 - jCPointRect.x1) * (double)(jCPointRect.y2 - jCPointRect.y1);
    }

    static JCRectList[] make(JCRectList jCRectList) {
        if (jCRectList.head == null) {
            JCRectList[] jCRectListArray = null;
            return jCRectListArray;
        }
        int n = jCRectList.head.rect.y;
        int n2 = 1;
        JCRectNode jCRectNode = jCRectList.head.next;
        while (jCRectNode != null) {
            if (jCRectNode.rect.y != n) {
                n = jCRectNode.rect.y;
                ++n2;
            }
            jCRectNode = jCRectNode.next;
        }
        int n3 = n2 + 1;
        JCRectList[] jCRectListArray = new JCRectList[n3];
        if (jCRectListArray == null) {
            return jCRectListArray;
        }
        n2 = 0;
        while (n2 < n3) {
            jCRectListArray[n2] = new JCRectList();
            ++n2;
        }
        int n4 = 0;
        JCRectList jCRectList2 = jCRectListArray[n4];
        jCRectNode = jCRectList.head;
        JCRectUtil.rl_init(jCRectNode.rect, jCRectList2);
        n = jCRectNode.rect.y;
        jCRectNode = jCRectNode.next;
        while (jCRectNode != null) {
            if (jCRectNode.rect.y == n) {
                JCRectUtil.appendrect(jCRectNode.rect, jCRectList2);
            } else {
                JCRectUtil.sort(jCRectList2, jCRectList2, 0);
                jCRectList2 = jCRectListArray[++n4];
                n = jCRectNode.rect.y;
                JCRectUtil.rl_init(jCRectNode.rect, jCRectList2);
            }
            jCRectNode = jCRectNode.next;
        }
        JCRectUtil.sort(jCRectList2, jCRectList2, 0);
        return jCRectListArray;
    }

    static void normalize(JCRectList jCRectList) {
        JCRectNode jCRectNode = jCRectList.head;
        while (jCRectNode != null) {
            if (jCRectNode.rect.width < 0) {
                jCRectNode.rect.x += jCRectNode.rect.width;
                jCRectNode.rect.width = -jCRectNode.rect.width;
            }
            if (jCRectNode.rect.height < 0) {
                jCRectNode.rect.y += jCRectNode.rect.height;
                jCRectNode.rect.height = -jCRectNode.rect.height;
            }
            jCRectNode = jCRectNode.next;
        }
    }

    public static void rl_init(Rectangle rectangle, JCRectList jCRectList) {
        JCRectNode jCRectNode = new JCRectNode();
        jCRectNode.rect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jCRectList.head = jCRectList.tail = jCRectNode;
    }

    public static void rl_remove(Rectangle rectangle, JCRectList jCRectList, JCRectList jCRectList2) {
        JCRectList jCRectList3 = new JCRectList();
        JCRectNode jCRectNode = jCRectList.head;
        while (jCRectNode != null) {
            JCRectUtil.appendremaining(rectangle, jCRectNode.rect, jCRectList3);
            jCRectNode = jCRectNode.next;
        }
        jCRectList2.head = jCRectList3.head;
        jCRectList2.tail = jCRectList3.tail;
    }

    static void search_lg_rect(JCRectList[] jCRectListArray, int n, JCRectNode jCRectNode, Rectangle rectangle, Rectangle rectangle2) {
        JCRectList jCRectList = jCRectListArray[n];
        if (jCRectList == null) {
            return;
        }
        JCRectNode jCRectNode2 = jCRectNode;
        while (jCRectNode2 != null) {
            JCRectUtil.calc_lg_rect(rectangle, rectangle2, jCRectNode2.rect);
            jCRectNode2 = jCRectNode2.next;
        }
        int n2 = n + 1;
        JCRectList jCRectList2 = jCRectListArray[n2];
        while (jCRectList2.head != null) {
            jCRectNode2 = jCRectList2.head;
            while (jCRectNode2 != null) {
                Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                JCRectUtil.calc_lg_rect(rectangle, rectangle3, jCRectNode2.rect);
                JCRectUtil.search_lg_rect(jCRectListArray, n2, jCRectNode2, rectangle, rectangle3);
                jCRectNode2 = jCRectNode2.next;
            }
            jCRectList2 = jCRectListArray[++n2];
        }
    }

    static void sort(JCRectList jCRectList, JCRectList jCRectList2, int n) {
        JCRectNode jCRectNode = jCRectList.head;
        int n2 = 0;
        while (jCRectNode != null) {
            jCRectNode = jCRectNode.next;
            ++n2;
        }
        Vector<JCRectNode> vector = new Vector<JCRectNode>();
        jCRectNode = jCRectList.head;
        int n3 = 0;
        while (jCRectNode != null) {
            vector.addElement(jCRectNode);
            jCRectNode = jCRectNode.next;
            ++n3;
        }
        JCSortInterface jCSortInterface = n == 0 ? new JCRectSortLR() : new JCRectSortTB();
        new JCqsort(vector, jCSortInterface).sort(0);
        jCRectList2.head = null;
        jCRectList2.tail = null;
        n3 = 0;
        while (n3 < n2) {
            JCRectUtil.appendrectnode((JCRectNode)vector.elementAt(n3), jCRectList2);
            ++n3;
        }
    }
}

