/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jclass.beans.GroupPanel;
import jclass.table3.JCCellRange;
import jclass.table3.JCTblRevConverter;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.SpanRenderer;
import jclass.util.JCVector;

public class SpanningCellsEditor
extends SeriesEditor
implements ActionListener {
    private Button buttonSpan;
    private Button buttonUnspan;

    public SpanningCellsEditor() {
        super("Only 2 cells may be spanned in this version.", 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonSpan) || object.equals(this.buttonUnspan)) {
            this.updateSpan(object.equals(this.buttonSpan));
            JCCellRange jCCellRange = new JCCellRange();
            if (this.tableView.getSelectedRange(0, jCCellRange)) {
                this.updatePropertyPanel(jCCellRange);
            }
        }
    }

    private boolean canSpan(JCCellRange jCCellRange) {
        return !this.isSpanned(jCCellRange) && jCCellRange != null;
    }

    public String getAsText() {
        return this.getStringValue(this.nl);
    }

    public String getJavaInitializationString() {
        return "jclass.table3.JCTblConverter.toRangeList(\"" + this.getAsText() + "\")";
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new SpanRenderer(this);
    }

    private String getStringValue(String string) {
        return JCTblRevConverter.fromRangeList((JCVector)this.getValue());
    }

    public Object getValue() {
        return this.tableView.getSpanningCells();
    }

    private boolean isSpanned(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return false;
        }
        int n = jCCellRange.start_row;
        while (n <= jCCellRange.end_row) {
            int n2 = jCCellRange.start_column;
            while (n2 <= jCCellRange.end_column) {
                if (this.tableView.isSpanned(n, n2)) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    protected Component makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel("Spanning cells");
        groupPanel.setLayout(new FlowLayout());
        this.buttonSpan = new Button("Span");
        this.buttonUnspan = new Button("Unspan");
        this.buttonSpan.setEnabled(false);
        this.buttonUnspan.setEnabled(false);
        groupPanel.add(this.buttonSpan);
        groupPanel.add(this.buttonUnspan);
        this.buttonSpan.addActionListener(this);
        this.buttonUnspan.addActionListener(this);
        return groupPanel;
    }

    private void removeSpan(JCCellRange jCCellRange) {
        if (jCCellRange != null) {
            int n = jCCellRange.start_row;
            while (n <= jCCellRange.end_row) {
                int n2 = jCCellRange.start_column;
                while (n2 <= jCCellRange.end_column) {
                    this.tableView.removeSpan(n, n2);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void setValue(Object object) {
        this.tableView.setSpanningCells((Vector)object);
        super.setValue(object);
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("spanningCells", null, this.getValue());
        if (jCCellRange == null) {
            return;
        }
        this.buttonSpan.setEnabled(this.canSpan(jCCellRange));
        this.buttonUnspan.setEnabled(this.isSpanned(jCCellRange));
    }

    private void updateSpan(boolean bl) {
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        if (bl) {
            if (Math.abs(jCCellRange.end_row - jCCellRange.start_row) > 1 || Math.abs(jCCellRange.end_column - jCCellRange.start_column) > 1 || Math.abs(jCCellRange.end_row - jCCellRange.start_row) > 0 && Math.abs(jCCellRange.end_column - jCCellRange.start_column) > 0) {
                return;
            }
            this.tableView.addSpan(jCCellRange);
        } else {
            this.removeSpan(jCCellRange);
        }
    }
}

