/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import jclass.table3.PrintWrapper;

public class PrintingEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener,
ItemListener {
    Panel propertyPanel = null;
    Checkbox showMenu = null;
    Checkbox showPreview = null;
    Checkbox headerchk = null;
    TextField header = null;
    Checkbox footerchk = null;
    TextField footer = null;

    public PrintingEditor() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.header) {
            this.firePropertyChange();
        } else if (actionEvent.getSource() == this.footer) {
            this.firePropertyChange();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.header) {
            this.firePropertyChange();
        } else if (focusEvent.getSource() == this.footer) {
            this.firePropertyChange();
        }
    }

    public String getAsText() {
        return null;
    }

    public Component getCustomEditor() {
        return this.propertyPanel;
    }

    public String getJavaInitializationString() {
        String string = "\"" + (this.headerchk.getState() ? this.header.getText() : new String("")) + "\"";
        String string2 = "\"" + (this.footerchk.getState() ? this.footer.getText() : new String("")) + "\"";
        String string3 = String.valueOf(this.showMenu.getState());
        String string4 = String.valueOf(this.showPreview.getState());
        String string5 = new String("new jclass.table3.PrintWrapper(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        return string5;
    }

    public Object getValue() {
        return new PrintWrapper(this.headerchk.getState() ? this.header.getText() : new String(""), this.footerchk.getState() ? this.footer.getText() : new String(""), this.showMenu.getState(), this.showPreview.getState());
    }

    public void init() {
        this.propertyPanel = new Panel();
        this.propertyPanel.setLayout(new BorderLayout());
        this.showMenu = new Checkbox("Enable Print Menu");
        this.showMenu.addItemListener(this);
        this.showPreview = new Checkbox("Enable Print Preview");
        this.showPreview.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 2, 2, 2));
        panel.add(this.showMenu);
        panel.add(this.showPreview);
        this.headerchk = new Checkbox("Use Header");
        this.headerchk.addItemListener(this);
        this.header = new TextField(30);
        this.header.addFocusListener(this);
        this.header.addActionListener(this);
        panel.add(this.headerchk);
        panel.add(this.header);
        this.footerchk = new Checkbox("Use Footer");
        this.footerchk.addItemListener(this);
        this.footer = new TextField(30);
        this.footer.addFocusListener(this);
        this.footer.addActionListener(this);
        panel.add(this.footerchk);
        panel.add(this.footer);
        panel.add(new Label("Use ^P for page number."));
        this.propertyPanel.add("South", panel);
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.showMenu) {
            if (!this.showMenu.getState()) {
                this.showPreview.setEnabled(false);
                this.headerchk.setEnabled(false);
                this.header.setEnabled(false);
                this.footerchk.setEnabled(false);
                this.footer.setEnabled(false);
            } else {
                this.showPreview.setEnabled(true);
                this.headerchk.setEnabled(true);
                this.header.setEnabled(true);
                this.footerchk.setEnabled(true);
                this.footer.setEnabled(true);
            }
            this.firePropertyChange();
        } else if (itemEvent.getSource() == this.showPreview) {
            if (!this.showPreview.getState()) {
                this.headerchk.setEnabled(false);
                this.header.setEnabled(false);
                this.footerchk.setEnabled(false);
                this.footer.setEnabled(false);
            } else {
                this.headerchk.setEnabled(true);
                this.header.setEnabled(true);
                this.footerchk.setEnabled(true);
                this.footer.setEnabled(true);
            }
            this.firePropertyChange();
        } else if (itemEvent.getSource() == this.headerchk) {
            if (this.headerchk.getState()) {
                this.header.setEnabled(true);
            } else {
                this.header.setEnabled(false);
            }
            this.firePropertyChange();
        } else if (itemEvent.getSource() == this.footerchk) {
            if (this.footerchk.getState()) {
                this.footer.setEnabled(true);
            } else {
                this.footer.setEnabled(false);
            }
            this.firePropertyChange();
        }
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new PrintWrapper(new String(""), new String(""), true, true);
        }
        PrintWrapper printWrapper = (PrintWrapper)object;
        this.header.setText(printWrapper.printHeader);
        if (!printWrapper.printHeader.equals("")) {
            this.headerchk.setState(true);
        }
        this.footer.setText(printWrapper.printFooter);
        if (!printWrapper.printFooter.equals("")) {
            this.footerchk.setState(true);
        }
        this.showMenu.setState(printWrapper.showPrintMenu);
        this.showPreview.setState(printWrapper.showPrintPreview);
        this.showPreview.setEnabled(true);
        this.headerchk.setEnabled(true);
        this.header.setEnabled(true);
        this.footerchk.setEnabled(true);
        this.footer.setEnabled(true);
        if (!this.showMenu.getState()) {
            this.showPreview.setEnabled(false);
            this.headerchk.setEnabled(false);
            this.header.setEnabled(false);
            this.footerchk.setEnabled(false);
            this.footer.setEnabled(false);
        }
        if (!this.showPreview.getState()) {
            this.headerchk.setEnabled(false);
            this.header.setEnabled(false);
            this.footerchk.setEnabled(false);
            this.footer.setEnabled(false);
        }
        if (!this.headerchk.getState()) {
            this.header.setEnabled(false);
        }
        if (!this.footerchk.getState()) {
            this.footer.setEnabled(false);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

